
/****** Object:  Table [dbo].[daily_report_2]    Script Date: 2/22/2019 4:17:28 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_2]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[daily_report_2](
	[dr_id] [int] IDENTITY(1,1) NOT NULL,
	[dr_create_date] [date] NULL,
	[dr_create_time] [time](7) NULL,
	[dr_job_name] [nvarchar](50) NULL,
	[dr_job_no] [nvarchar](50) NULL,
	[dr_shift_date] [date] NULL,
	[dr_shift_time_start] [time](7) NULL,
	[dr_shift_time_end] [time](7) NULL,
	[dr_lunch_time_start] [time](7) NULL,
	[dr_lunch_time_end] [time](7) NULL,
	[dr_foreman] [nvarchar](50) NULL,
	[dr_foreman_id] [nvarchar](50) NULL,
	[dr_super] [nvarchar](50) NULL,
	[dr_super_id] [nvarchar](50) NULL,
	[dr_pm] [nvarchar](50) NULL,
	[dr_pm_id] [nvarchar](50) NULL,
	[dr_pe] [nvarchar](50) NULL,
	[dr_pe_id] [nvarchar](50) NULL,
	[dr_status] [nvarchar](50) NULL,
	[dr_reject_reason] [nvarchar](500) NULL,
	[dr_approver] [nvarchar](50) NULL,
	[dr_approver_userid] [nvarchar](50) NULL,
	[dr_approve_date] [date] NULL,
	[dr_approve_time] [time](7) NULL,
	[dr_approve_datetime] [datetime] NULL,
	[dr_rejector] [nvarchar](50) NULL,
	[dr_rejector_userid] [nvarchar](50) NULL,
	[dr_rejector_date] [date] NULL,
	[dr_rejector_time] [time](7) NULL,
	[dr_rejector_datetime] [datetime] NULL,
	[dr_foreman_submit_date] [date] NULL,
	[dr_foreman_submit_time] [time](7) NULL,
	[dr_foreman_submit_datetime] [datetime] NULL,
	[dr_total_daily_hours] [decimal](5, 1) NULL,
	[dr_job_search] [nvarchar](50) NULL,
	[dr_empl_number] [int] NULL,
 CONSTRAINT [PK_daily_report_new] PRIMARY KEY CLUSTERED 
(
	[dr_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[daily_report_employee_2]    Script Date: 2/22/2019 4:17:29 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_employee_2]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[daily_report_employee_2](
	[empl_id] [int] IDENTITY(37000,1) NOT NULL,
	[empl_dr_id] [int] NULL,
	[empl_name] [nvarchar](50) NULL,
	[empl_name_id] [nvarchar](50) NULL,
	[empl_hours] [decimal](5, 1) NULL,
	[empl_hours_to_go] [decimal](5, 1) NULL,
	[empl_datetime_added] [datetime] NULL,
	[empl_added_by] [nvarchar](50) NULL,
	[empl_department] [nvarchar](50) NULL,
	[empl_company] [nvarchar](50) NULL,
	[empl_search] [nvarchar](50) NULL,
	[empl_notes] [nvarchar](1000) NULL,
	[empl_sick] [bit] NULL,
	[empl_on_goal] [bit] NULL,
 CONSTRAINT [PK_daily_report_empl_2] PRIMARY KEY CLUSTERED 
(
	[empl_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[daily_report_employee_master]    Script Date: 2/22/2019 4:17:29 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_employee_master]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[daily_report_employee_master](
	[Company_Code] [varchar](3) NOT NULL,
	[Employee_Code] [varchar](11) NOT NULL,
	[YTD_Pay_List1] [decimal](12, 2) NOT NULL,
	[YTD_Pay_List2] [decimal](12, 2) NOT NULL,
	[YTD_Pay_List3] [decimal](12, 2) NOT NULL,
	[YTD_Pay_List4] [decimal](12, 2) NOT NULL,
	[YTD_Pay_List5] [decimal](12, 2) NOT NULL,
	[YTD_Pay_List6] [decimal](12, 2) NOT NULL,
	[YTD_Pay_List7] [decimal](12, 2) NOT NULL,
	[YTD_Pay_List8] [decimal](12, 2) NOT NULL,
	[YTD_Pay_List9] [decimal](12, 2) NOT NULL,
	[YTD_Pay_List10] [decimal](12, 2) NOT NULL,
	[YTD_Pay_List11] [decimal](12, 2) NOT NULL,
	[QTD_Amounts_List1] [decimal](12, 2) NOT NULL,
	[QTD_Amounts_List2] [decimal](12, 2) NOT NULL,
	[QTD_Amounts_List3] [decimal](12, 2) NOT NULL,
	[QTD_Amounts_List4] [decimal](12, 2) NOT NULL,
	[QTD_Amounts_List5] [decimal](12, 2) NOT NULL,
	[QTD_Amounts_List6] [decimal](12, 2) NOT NULL,
	[QTD_Amounts_List7] [decimal](12, 2) NOT NULL,
	[QTD_Amounts_List8] [decimal](12, 2) NOT NULL,
	[QTD_Amounts_List9] [decimal](12, 2) NOT NULL,
	[QTD_Amounts_List10] [decimal](12, 2) NOT NULL,
	[QTD_Amounts_List11] [decimal](12, 2) NOT NULL,
	[MTD_Amounts_List1] [decimal](12, 2) NOT NULL,
	[MTD_Amounts_List2] [decimal](12, 2) NOT NULL,
	[MTD_Amounts_List3] [decimal](12, 2) NOT NULL,
	[MTD_Amounts_List4] [decimal](12, 2) NOT NULL,
	[MTD_Amounts_List5] [decimal](12, 2) NOT NULL,
	[MTD_Amounts_List6] [decimal](12, 2) NOT NULL,
	[MTD_Amounts_List7] [decimal](12, 2) NOT NULL,
	[MTD_Amounts_List8] [decimal](12, 2) NOT NULL,
	[MTD_Amounts_List9] [decimal](12, 2) NOT NULL,
	[MTD_Amounts_List10] [decimal](12, 2) NOT NULL,
	[MTD_Amounts_List11] [decimal](12, 2) NOT NULL,
	[Burden_Amount_List1] [decimal](12, 2) NOT NULL,
	[Burden_Amount_List2] [decimal](12, 2) NOT NULL,
	[Burden_Amount_List3] [decimal](12, 2) NOT NULL,
	[Burden_Amount_List4] [decimal](12, 2) NOT NULL,
	[Burden_Amount_List5] [decimal](12, 2) NOT NULL,
	[Burden_Amount_List6] [decimal](12, 2) NOT NULL,
	[Burden_Amount_List7] [decimal](12, 2) NOT NULL,
	[Burden_Amount_List8] [decimal](12, 2) NOT NULL,
	[Burden_Amount_List9] [decimal](12, 2) NOT NULL,
	[Burden_Amount_List10] [decimal](12, 2) NOT NULL,
	[Burden_Amount_List11] [decimal](12, 2) NOT NULL,
	[Burden_Amount_List12] [decimal](12, 2) NOT NULL,
	[Vacation_Hours_Balance_List1] [decimal](12, 4) NOT NULL,
	[Vacation_Hours_Balance_List2] [decimal](12, 4) NOT NULL,
	[Holiday_Hours_Balance_List1] [decimal](12, 4) NOT NULL,
	[Holiday_Hours_Balance_List2] [decimal](12, 4) NOT NULL,
	[Sick_Hours_Balance_List1] [decimal](12, 4) NOT NULL,
	[Sick_Hours_Balance_List2] [decimal](12, 4) NOT NULL,
	[Accrual_Control_Code_List1] [varchar](2) NOT NULL,
	[Accrual_Control_Code_List2] [varchar](2) NOT NULL,
	[Accrual_Control_Code_List3] [varchar](2) NOT NULL,
	[Control_Flag] [decimal](12, 2) NOT NULL,
	[Employee_401K_List1] [decimal](12, 2) NOT NULL,
	[Employee_401K_List2] [decimal](12, 2) NOT NULL,
	[Employee_401K_List3] [decimal](12, 2) NOT NULL,
	[Cafeteria_Amount_List1] [decimal](12, 2) NOT NULL,
	[Cafeteria_Amount_List2] [decimal](12, 2) NOT NULL,
	[Cafeteria_Amount_List3] [decimal](12, 2) NOT NULL,
	[YTD_Medicare] [decimal](12, 2) NOT NULL,
	[Employer_Medicare] [decimal](12, 2) NOT NULL,
	[Temp_FICA_List1] [decimal](12, 2) NOT NULL,
	[Temp_FICA_List2] [decimal](12, 2) NOT NULL,
	[Temp_FICA_List3] [decimal](12, 2) NOT NULL,
	[Temp_FICA_List4] [decimal](12, 2) NOT NULL,
	[QTD_Medicare] [decimal](12, 2) NOT NULL,
	[MTD_Medicare] [decimal](12, 2) NOT NULL,
	[Hours_Worked_List1] [decimal](12, 2) NOT NULL,
	[Hours_Worked_List2] [decimal](12, 2) NOT NULL,
	[Hours_Worked_List3] [decimal](12, 2) NOT NULL,
	[Other_Hours_List1] [decimal](12, 2) NOT NULL,
	[Other_Hours_List2] [decimal](12, 2) NOT NULL,
	[Other_Hours_List3] [decimal](12, 2) NOT NULL,
	[Worker_Comp_Amount_List1] [decimal](12, 2) NOT NULL,
	[Worker_Comp_Amount_List2] [decimal](12, 2) NOT NULL,
	[Worker_Comp_Amount_List3] [decimal](12, 2) NOT NULL,
	[Total_State_Taxable_List1] [decimal](12, 2) NOT NULL,
	[Total_State_Taxable_List2] [decimal](12, 2) NOT NULL,
	[Total_State_Taxable_List3] [decimal](12, 2) NOT NULL,
	[Total_State_Taxable_List4] [decimal](12, 2) NOT NULL,
	[Employee_Liability1] [decimal](12, 2) NOT NULL,
	[Employee_Liability2] [decimal](12, 2) NOT NULL,
	[Employee_Liability3] [decimal](12, 2) NOT NULL,
	[Employee_Previous_Accrual1] [datetime] NULL,
	[Employee_Previous_Accrual2] [datetime] NULL,
	[Employee_Previous_Accrual3] [datetime] NULL,
	[Total_County_Taxable_List1] [decimal](12, 2) NOT NULL,
	[Total_County_Taxable_List2] [decimal](12, 2) NOT NULL,
	[Total_County_Taxable_List3] [decimal](12, 2) NOT NULL,
	[Total_County_Taxable_List4] [decimal](12, 2) NOT NULL,
	[Total_Local_Taxable_List1] [decimal](12, 2) NOT NULL,
	[Total_Local_Taxable_List2] [decimal](12, 2) NOT NULL,
	[Total_Local_Taxable_List3] [decimal](12, 2) NOT NULL,
	[Total_Local_Taxable_List4] [decimal](12, 2) NOT NULL,
	[Davis_Bacon_Gross_List1] [decimal](12, 2) NOT NULL,
	[Davis_Bacon_Gross_List2] [decimal](12, 2) NOT NULL,
	[Davis_Bacon_Gross_List3] [decimal](12, 2) NOT NULL,
	[Prevailing_Wage_Gross_List1] [decimal](12, 2) NOT NULL,
	[Prevailing_Wage_Gross_List2] [decimal](12, 2) NOT NULL,
	[Prevailing_Wage_Gross_List3] [decimal](12, 2) NOT NULL,
	[Total_State_SUTA_Excess] [decimal](12, 2) NOT NULL,
	[Total_County_SUTA_Excess] [decimal](12, 2) NOT NULL,
	[Total_Local_SUTA_Excess] [decimal](12, 2) NOT NULL,
 CONSTRAINT [PK_daily_PR_EMPLOYEE_MASTER_2_MC] PRIMARY KEY CLUSTERED 
(
	[Company_Code] ASC,
	[Employee_Code] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[daily_report_employee_master_1]    Script Date: 2/22/2019 4:17:29 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_employee_master_1]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[daily_report_employee_master_1](
	[Company_Code] [varchar](3) NOT NULL,
	[Employee_Code] [varchar](11) NOT NULL,
	[Employee_Name] [varchar](30) NOT NULL,
	[Alpha_Sort] [varchar](8) NOT NULL,
	[Street_Address] [varchar](25) NOT NULL,
	[Address] [varchar](25) NOT NULL,
	[State] [varchar](2) NOT NULL,
	[Zip_Code] [varchar](10) NOT NULL,
	[Phone] [varchar](14) NOT NULL,
	[Social_Security] [varchar](9) NOT NULL,
	[Employee_Date_List1] [datetime] NULL,
	[Employee_Date_List2] [datetime] NULL,
	[Employee_Date_List3] [datetime] NULL,
	[Employee_Date_List4] [datetime] NULL,
	[Employee_Date_List5] [datetime] NULL,
	[Employee_Date_List6] [datetime] NULL,
	[Employee_Date_List7] [datetime] NULL,
	[Sex] [varchar](1) NOT NULL,
	[Race] [varchar](1) NOT NULL,
	[Marital_Status] [varchar](1) NOT NULL,
	[Casual_Flag] [varchar](1) NOT NULL,
	[Pay_Frequency_Flag] [varchar](1) NOT NULL,
	[Pay_Type] [varchar](1) NOT NULL,
	[Last_Pay_Type] [varchar](1) NOT NULL,
	[Spouse_Name] [varchar](15) NOT NULL,
	[Title] [varchar](50) NOT NULL,
	[Supervisor_Code] [varchar](2) NOT NULL,
	[Tax_Control_Flag_List1] [varchar](1) NOT NULL,
	[Tax_Control_Flag_List2] [varchar](1) NOT NULL,
	[Tax_Control_Flag_List3] [varchar](1) NOT NULL,
	[Tax_Control_Flag_List4] [varchar](1) NOT NULL,
	[Tax_Control_Flag_List5] [varchar](1) NOT NULL,
	[Tax_Control_Flag_List6] [varchar](1) NOT NULL,
	[Tax_Control_Flag_List7] [varchar](1) NOT NULL,
	[Tax_Control_Flag_List8] [varchar](1) NOT NULL,
	[Tax_Control_Flag_List9] [varchar](1) NOT NULL,
	[Tax_Control_Flag_List10] [varchar](1) NOT NULL,
	[Tax_Control_Flag_List11] [varchar](1) NOT NULL,
	[Filing_Status_List1] [varchar](20) NOT NULL,
	[Filing_Status_List2] [varchar](20) NOT NULL,
	[Filing_Status_List3] [varchar](20) NOT NULL,
	[Filing_Status_List4] [varchar](20) NOT NULL,
	[Filing_Status_List5] [varchar](20) NOT NULL,
	[Tax_Table_Codes_List1] [varchar](10) NOT NULL,
	[Tax_Table_Codes_List2] [varchar](10) NOT NULL,
	[Tax_Table_Codes_List3] [varchar](10) NOT NULL,
	[Tax_Table_Codes_List4] [varchar](10) NOT NULL,
	[Tax_Table_Codes_List5] [varchar](10) NOT NULL,
	[Number_Of_Exemptions_List1] [decimal](12, 2) NOT NULL,
	[Number_Of_Exemptions_List2] [decimal](12, 2) NOT NULL,
	[Number_Of_Exemptions_List3] [decimal](12, 2) NOT NULL,
	[Number_Of_Exemptions_List4] [decimal](12, 2) NOT NULL,
	[Number_Of_Exemptions_List5] [decimal](12, 2) NOT NULL,
	[Tax_Add_List1] [decimal](12, 2) NOT NULL,
	[Tax_Add_List2] [decimal](12, 2) NOT NULL,
	[Tax_Add_List3] [decimal](12, 2) NOT NULL,
	[Tax_Add_List4] [decimal](12, 2) NOT NULL,
	[Tax_Add_List5] [decimal](12, 2) NOT NULL,
	[Tax_Amount_Control_List1] [varchar](1) NOT NULL,
	[Tax_Amount_Control_List2] [varchar](1) NOT NULL,
	[Tax_Amount_Control_List3] [varchar](1) NOT NULL,
	[Tax_Amount_Control_List4] [varchar](1) NOT NULL,
	[Tax_Amount_Control_List5] [varchar](1) NOT NULL,
	[Delete_Flag] [varchar](1) NOT NULL,
	[Employment_Status] [varchar](1) NOT NULL,
	[Minimum_Earnings] [decimal](12, 2) NOT NULL,
	[Number_Of_Dependents] [decimal](12, 2) NOT NULL,
	[Worker_Comp_Code] [varchar](6) NOT NULL,
	[Bank_Account_Number] [varchar](17) NOT NULL,
	[Driver_License] [varchar](25) NOT NULL,
	[Last_Pay_Rate] [decimal](12, 2) NOT NULL,
	[Hourly_Rate] [decimal](12, 4) NOT NULL,
	[Salary_Amount] [decimal](12, 2) NOT NULL,
	[Annual_Pay_Rate] [decimal](12, 2) NOT NULL,
	[Special_Pay_Rate] [decimal](12, 2) NOT NULL,
	[Special_Pay_Amount] [decimal](12, 2) NOT NULL,
	[Meal_Allowance_Rate] [decimal](12, 2) NOT NULL,
	[Department_Code] [varchar](6) NOT NULL,
	[Selected_Flag] [varchar](1) NOT NULL,
	[Months_To_Next_Review] [decimal](12, 2) NOT NULL,
	[Emergency_Contact] [varchar](25) NOT NULL,
	[Emergency_Phone] [varchar](14) NOT NULL,
	[Emergency_Relationship] [varchar](15) NOT NULL,
	[Not_Used1] [decimal](12, 2) NOT NULL,
	[Not_Used2] [decimal](12, 2) NOT NULL,
	[Not_Used3] [decimal](12, 2) NOT NULL,
	[Hours_List1] [decimal](12, 2) NOT NULL,
	[Hours_List2] [decimal](12, 2) NOT NULL,
	[Hours_List3] [decimal](12, 2) NOT NULL,
	[Standard_Work_Hours] [decimal](12, 2) NOT NULL,
	[Union_Code] [varchar](10) NOT NULL,
	[Total_Hours] [decimal](12, 2) NOT NULL,
	[Check_Type] [varchar](1) NOT NULL,
	[Manual_Check_Number] [decimal](12, 2) NOT NULL,
	[OT_Hours] [decimal](12, 2) NOT NULL,
	[Domicile_Address] [varchar](25) NOT NULL,
	[Domicile_City] [varchar](25) NOT NULL,
	[Domicile_State] [varchar](2) NOT NULL,
	[Domicile_Zip_Code] [varchar](10) NOT NULL,
	[Pay_Rate_Code] [varchar](1) NOT NULL,
	[Employee_Work_Class] [varchar](1) NOT NULL,
	[ABA_Number] [varchar](9) NOT NULL,
	[Bank_Account_Type] [varchar](1) NOT NULL,
	[Wage_Class] [varchar](10) NOT NULL,
	[Certified_Flag] [varchar](1) NOT NULL,
	[Billing_Code] [varchar](10) NOT NULL,
	[I9_Flag] [varchar](1) NOT NULL,
	[I9_Expire_Date] [datetime] NULL,
	[EEO_Class_Code] [varchar](3) NOT NULL,
	[Stop_Tax_Flag_List1] [varchar](1) NOT NULL,
	[Stop_Tax_Flag_List2] [varchar](1) NOT NULL,
	[Stop_Tax_Flag_List3] [varchar](1) NOT NULL,
	[Stop_Tax_Flag_List4] [varchar](1) NOT NULL,
	[Auto_Deposit_Flag] [varchar](1) NOT NULL,
	[Burden_Percent] [decimal](12, 2) NOT NULL,
	[Prevail_Wage_Fringe_Rate] [decimal](12, 2) NOT NULL,
	[Pay_Rate_Percent] [decimal](12, 2) NOT NULL,
	[ABA_Number_2] [varchar](9) NOT NULL,
	[ABA_Number_3] [varchar](9) NOT NULL,
	[ABA_Number_4] [varchar](9) NOT NULL,
	[ABA_Number_5] [varchar](9) NOT NULL,
	[Bank_Account_Type_2] [varchar](1) NOT NULL,
	[Bank_Account_Type_3] [varchar](1) NOT NULL,
	[Bank_Account_Type_4] [varchar](1) NOT NULL,
	[Bank_Account_Type_5] [varchar](1) NOT NULL,
	[Bank_Account_Number_2] [varchar](17) NOT NULL,
	[Bank_Account_Number_3] [varchar](17) NOT NULL,
	[Bank_Account_Number_4] [varchar](17) NOT NULL,
	[Bank_Account_Number_5] [varchar](17) NOT NULL,
	[Auto_Deposit_Flag_2] [varchar](1) NOT NULL,
	[Auto_Deposit_Flag_3] [varchar](1) NOT NULL,
	[Auto_Deposit_Flag_4] [varchar](1) NOT NULL,
	[Auto_Deposit_Flag_5] [varchar](1) NOT NULL,
	[Auto_Deposit_Allocation] [varchar](1) NOT NULL,
	[Auto_Deposit_Rate1] [decimal](12, 2) NOT NULL,
	[Auto_Deposit_Rate2] [decimal](12, 2) NOT NULL,
	[Auto_Deposit_Rate3] [decimal](12, 2) NOT NULL,
	[Auto_Deposit_Rate4] [decimal](12, 2) NOT NULL,
	[Auto_Deposit_Rate5] [decimal](12, 2) NOT NULL,
	[First_Name] [varchar](20) NOT NULL,
	[Middle_Name] [varchar](20) NOT NULL,
	[Last_Name] [varchar](30) NOT NULL,
	[Occupation] [varchar](50) NOT NULL,
	[Trade] [varchar](50) NOT NULL,
	[Street_Address2] [varchar](25) NOT NULL,
	[Domicile_Address2] [varchar](25) NOT NULL,
	[Effective_Date] [datetime] NULL,
	[Comments] [varchar](40) NOT NULL,
	[Cost_Center] [varchar](10) NOT NULL,
	[Emp_Foreign] [varchar](1) NOT NULL,
	[Perm_Work_Comp] [varchar](1) NOT NULL,
	[Contact_ID] [int] NOT NULL,
	[Permanent_Unemployment_State] [varchar](10) NOT NULL,
	[Wrk_Mobile_ID] [int] NOT NULL,
	[Wrk_Ext_ID] [int] NOT NULL,
	[Encrypted_Social_Security] [varbinary](68) NULL,
	[Encrypted_Driver_License] [varbinary](84) NULL,
	[Encrypted_Bank_Account_Number] [varbinary](68) NULL,
	[Encrypted_Bank_Account_Number_2] [varbinary](68) NULL,
	[Encrypted_Bank_Account_Number_3] [varbinary](68) NULL,
	[Encrypted_Bank_Account_Number_4] [varbinary](68) NULL,
	[Encrypted_Bank_Account_Number_5] [varbinary](68) NULL,
	[id] [int] IDENTITY(1,1) NOT NULL,
 CONSTRAINT [PK_daily_PR_EMPLOYEE_MASTER_1_MC] PRIMARY KEY CLUSTERED 
(
	[Company_Code] ASC,
	[Employee_Code] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[daily_report_hours_2]    Script Date: 2/22/2019 4:17:30 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_hours_2]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[daily_report_hours_2](
	[hrs_id] [int] IDENTITY(1,1) NOT NULL,
	[hrs_dr_id] [int] NULL,
	[hrs_hours] [decimal](5, 1) NULL,
	[hrs_employee] [nvarchar](50) NULL,
	[hrs_employee_id] [nvarchar](50) NULL,
	[hrs_phase_code] [nvarchar](50) NULL,
	[hrs_phase_code_type] [nvarchar](50) NULL,
	[hrs_daily_hours_reached] [bit] NULL,
	[hrs_datetime_added] [datetime] NULL,
	[hrs_phase_search] [nvarchar](50) NULL,
	[hrs_job_no] [nvarchar](50) NULL,
	[hrs_phase_description] [nvarchar](50) NULL,
	[hrs_empl_to_go] [decimal](5, 1) NULL,
 CONSTRAINT [PK_daily_report_hours_2] PRIMARY KEY CLUSTERED 
(
	[hrs_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[daily_report_job_master]    Script Date: 2/22/2019 4:17:30 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_job_master]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[daily_report_job_master](
	[Company_Code] [varchar](3) NOT NULL,
	[Job_Number] [varchar](10) NOT NULL,
	[Master_Job] [varchar](10) NOT NULL,
	[Division] [varchar](5) NOT NULL,
	[Job_Description] [varchar](25) NOT NULL,
	[Address_1] [varchar](30) NOT NULL,
	[Address_2] [varchar](30) NOT NULL,
	[City] [varchar](25) NOT NULL,
	[State] [varchar](2) NOT NULL,
	[Zip_Code] [varchar](10) NOT NULL,
	[Phone] [varchar](14) NOT NULL,
	[Superintendent] [varchar](15) NOT NULL,
	[Estimator] [varchar](15) NOT NULL,
	[Certified_Flag] [varchar](1) NOT NULL,
	[Contract_Number] [varchar](30) NOT NULL,
	[Status_Code] [varchar](1) NOT NULL,
	[Total_Units] [decimal](12, 2) NOT NULL,
	[Unit_of_Measure] [varchar](5) NOT NULL,
	[Complete_Date] [datetime] NULL,
	[Start_Date] [datetime] NULL,
	[Est_Complete_Date] [datetime] NULL,
	[Est_Start_Date] [datetime] NULL,
	[Payroll_OH_Percent] [decimal](12, 2) NOT NULL,
	[OH_Phase] [varchar](20) NOT NULL,
	[OH_Cost_Type] [varchar](3) NOT NULL,
	[Customer_Code] [varchar](10) NOT NULL,
	[Index_Variable] [varchar](10) NOT NULL,
	[Index_Variable_2] [varchar](10) NOT NULL,
	[Burden_Flag] [varchar](1) NOT NULL,
	[Burden_Percent] [decimal](12, 2) NOT NULL,
	[Burden_Phase] [varchar](20) NOT NULL,
	[Burden_Cost_Type] [varchar](3) NOT NULL,
	[Job_Type] [varchar](10) NOT NULL,
	[Entered_Projected_Cost] [decimal](12, 2) NOT NULL,
	[Original_Contract] [decimal](12, 2) NOT NULL,
	[Sales_Tax_Code] [varchar](15) NOT NULL,
	[Job_Site_Phone] [varchar](14) NOT NULL,
	[Entered_Percent_Complete] [decimal](12, 2) NOT NULL,
	[Taxable_Flag] [varchar](1) NOT NULL,
	[Wage_Rate_Level] [decimal](12, 2) NOT NULL,
	[Work_Comp_Code] [varchar](6) NOT NULL,
	[Price_Method_Code] [varchar](1) NOT NULL,
	[Pre_TC_Burden_Percent] [decimal](12, 2) NOT NULL,
	[Phase_Display_Code] [varchar](20) NOT NULL,
	[Major_Group_Start] [decimal](12, 2) NOT NULL,
	[Major_Group_End] [decimal](12, 2) NOT NULL,
	[Minor_Group_Start] [decimal](12, 2) NOT NULL,
	[Minor_Group_End] [decimal](12, 2) NOT NULL,
	[Fax_Phone] [varchar](14) NOT NULL,
	[PR_OH_Type_Code] [varchar](1) NOT NULL,
	[PR_OH_Amount] [decimal](12, 2) NOT NULL,
	[Job_Oh_Batch_Code] [varchar](10) NOT NULL,
	[Wage_Code_Indicator] [varchar](1) NOT NULL,
	[Work_State_Tax_Code] [varchar](10) NOT NULL,
	[Work_County_Tax_Code] [varchar](10) NOT NULL,
	[Work_Local_Tax_Code] [varchar](10) NOT NULL,
	[Pay_Group] [varchar](6) NOT NULL,
	[Project_Manager] [varchar](15) NOT NULL,
	[Earned_Calc_Type] [varchar](1) NOT NULL,
	[Under_Billed] [decimal](12, 2) NOT NULL,
	[Cost_Markup_Percent] [decimal](12, 2) NOT NULL,
	[Tax_Class_Code] [varchar](15) NOT NULL,
	[Auto_Ot_Flag] [varchar](1) NOT NULL,
	[Ot_Over_Hrs] [decimal](12, 2) NOT NULL,
	[Dt_Over_Hrs] [decimal](12, 2) NOT NULL,
	[Period_Flag] [varchar](1) NOT NULL,
	[Routing_Code1] [varchar](10) NOT NULL,
	[Routing_Code2] [varchar](10) NOT NULL,
	[Routing_Limit] [decimal](12, 2) NOT NULL,
	[Standard_Phase_Category] [varchar](10) NOT NULL,
	[Track_Prevailing_Wage] [varchar](1) NOT NULL,
	[Track_Davis_Bacon] [varchar](1) NOT NULL,
	[Cost_Center] [varchar](10) NOT NULL,
	[Projected_Complete_Date] [datetime] NULL,
	[Latitude] [decimal](12, 6) NOT NULL,
	[Longitude] [decimal](12, 6) NOT NULL,
	[Create_Date] [datetime] NULL,
	[WO_Site] [varchar](10) NOT NULL,
	[Comment] [varchar](250) NOT NULL,
	[Certified_Project_ID] [varchar](50) NOT NULL,
	[Certified_Week_Type] [varchar](1) NOT NULL,
	[Lock_Revenue_Entry] [varchar](1) NOT NULL,
	[id] [int] IDENTITY(1,1) NOT NULL,
 CONSTRAINT [PK_daily_JC_JOB_MASTER_MC] PRIMARY KEY CLUSTERED 
(
	[Company_Code] ASC,
	[Job_Number] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[daily_report_phase_master]    Script Date: 2/22/2019 4:17:30 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_phase_master]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[daily_report_phase_master](
	[Company_Code] [varchar](3) NOT NULL,
	[Job_Number] [varchar](10) NOT NULL,
	[Phase_Code] [varchar](20) NOT NULL,
	[Cost_Type] [varchar](3) NOT NULL,
	[Description] [varchar](25) NOT NULL,
	[Status_Code] [varchar](1) NOT NULL,
	[Complete_Date] [datetime] NULL,
	[Unit_of_Measure] [varchar](3) NOT NULL,
	[Major_Group_Code] [varchar](6) NOT NULL,
	[Minor_Group_Code] [varchar](6) NOT NULL,
	[Start_Date] [datetime] NULL,
	[End_Date] [datetime] NULL,
	[Lead_Time_Days] [decimal](12, 2) NOT NULL,
	[Original_Est_Quantity] [decimal](12, 2) NOT NULL,
	[Original_Est_Cost] [decimal](12, 2) NOT NULL,
	[Original_Est_Hours] [decimal](12, 2) NOT NULL,
	[Last_Cost_Date] [datetime] NULL,
	[Work_Comp_Code] [varchar](6) NOT NULL,
	[TM_Markup_Flag] [varchar](1) NOT NULL,
	[Est_Unit_Cost] [decimal](12, 4) NOT NULL,
	[Bid_Item_Number] [varchar](10) NOT NULL,
	[Alt_Phase_Code] [varchar](20) NOT NULL,
	[Price_Method_Code] [varchar](1) NOT NULL,
	[Projected_Cost_Code] [varchar](1) NOT NULL,
	[Work_State_Tax_Code] [varchar](10) NOT NULL,
	[Work_County_Tax_Code] [varchar](10) NOT NULL,
	[Work_Local_Tax_Code] [varchar](10) NOT NULL,
	[Last_Payroll_Date] [datetime] NULL,
	[Certified_Flag] [varchar](1) NOT NULL,
	[Wage_Rate_Level] [decimal](12, 2) NOT NULL,
	[Wage_Code_Indicator] [varchar](1) NOT NULL,
	[Phase_Cost_Center] [varchar](10) NOT NULL,
	[Update_Proj_Qty] [varchar](1) NOT NULL,
	[Comment] [varchar](250) NOT NULL,
	[id] [int] IDENTITY(1,1) NOT NULL,
 CONSTRAINT [PK_daily_JC_PHASE_MASTER_MC] PRIMARY KEY CLUSTERED 
(
	[Company_Code] ASC,
	[Job_Number] ASC,
	[Phase_Code] ASC,
	[Cost_Type] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[daily_report_project_engineer]    Script Date: 2/22/2019 4:17:30 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_project_engineer]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[daily_report_project_engineer](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[create_user] [varchar](30) NULL,
	[create_date] [date] NULL,
	[create_time] [time](7) NULL,
	[userid] [varchar](255) NULL,
	[name] [varchar](100) NULL,
 CONSTRAINT [PK_daily_project_engineer] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[daily_report_project_log]    Script Date: 2/22/2019 4:17:31 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_project_log]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[daily_report_project_log](
	[log_id] [int] IDENTITY(1,1) NOT NULL,
	[log_dr_id] [int] NULL,
	[log_type] [nvarchar](50) NULL,
	[log_phase_code] [nvarchar](50) NULL,
	[log_phase_type] [nvarchar](50) NULL,
	[log_phase_description] [nvarchar](50) NULL,
	[log_job_num] [nvarchar](50) NULL,
	[log_description] [nvarchar](2000) NULL,
	[log_caused_by] [nvarchar](1000) NULL,
	[log_loss_time] [decimal](6, 1) NULL,
	[log_loss_hours] [decimal](6, 1) NULL,
	[log_loss_equipment] [nvarchar](500) NULL,
	[log_cause] [nvarchar](500) NULL,
	[log_from_time] [time](7) NULL,
	[log_to_time] [time](7) NULL,
	[log_received_from] [nvarchar](50) NULL,
	[log_authorized_by] [nvarchar](50) NULL,
	[log_performed_by] [nvarchar](50) NULL,
	[log_sub_lead] [nvarchar](100) NULL,
	[log_phase_search] [nvarchar](50) NULL,
	[log_attachment_counter] [int] NULL,
	[log_visitor] [nvarchar](500) NULL,
	[log_create_user] [nvarchar](50) NULL,
	[log_create_time] [datetime] NULL,
	[log_phase_code_sub] [nvarchar](50) NULL,
	[log_action_choice] [nvarchar](50) NULL,
	[log_phase_code_prod] [nvarchar](50) NULL,
	[log_last_updated] [datetime] NULL,
 CONSTRAINT [PK_daily_project_log] PRIMARY KEY CLUSTERED 
(
	[log_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[daily_report_project_managers]    Script Date: 2/22/2019 4:17:31 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_project_managers]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[daily_report_project_managers](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[create_user] [varchar](30) NULL,
	[create_date] [date] NULL,
	[create_time] [time](7) NULL,
	[userid] [varchar](255) NULL,
	[name] [varchar](50) NULL,
 CONSTRAINT [PK_daily_project_managers] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[daily_report_superintendents]    Script Date: 2/22/2019 4:17:31 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_superintendents]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[daily_report_superintendents](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[create_user] [varchar](30) NULL,
	[create_date] [date] NULL,
	[create_time] [time](7) NULL,
	[userid] [varchar](255) NULL,
	[name] [varchar](50) NULL,
 CONSTRAINT [PK_daily_supervisors] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  View [dbo].[daily_report_employee]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_employee]'))
EXEC dbo.sp_executesql @statement = N'CREATE 
--drop
VIEW [dbo].[daily_report_employee]
AS
SELECT        TOP (100) PERCENT Company_Code, LTRIM(RTRIM(Employee_Code)) AS Employee_Code, LTRIM(RTRIM(Employee_Name)) AS Employee_Name, Alpha_Sort, Street_Address, Address, State, Zip_Code, Phone, 
                         Employee_Date_List1, Employee_Date_List2, Employee_Date_List3, Employee_Date_List4, Employee_Date_List5, Employee_Date_List6, Employee_Date_List7, Sex, Race, Marital_Status, Casual_Flag, 
                         Pay_Frequency_Flag, Pay_Type, Last_Pay_Type, Spouse_Name, LTRIM(RTRIM(Title)) AS Title, LTRIM(RTRIM(Supervisor_Code)) AS Supervisor_Code, Tax_Control_Flag_List1, Tax_Control_Flag_List2, Tax_Control_Flag_List3, Tax_Control_Flag_List4, 
                         Tax_Control_Flag_List5, Tax_Control_Flag_List6, Tax_Control_Flag_List7, Tax_Control_Flag_List8, Tax_Control_Flag_List9, Tax_Control_Flag_List10, Tax_Control_Flag_List11, Filing_Status_List1, 
                         Filing_Status_List2, Filing_Status_List3, Filing_Status_List4, Filing_Status_List5, Tax_Table_Codes_List1, Tax_Table_Codes_List2, Tax_Table_Codes_List3, Tax_Table_Codes_List4, Tax_Table_Codes_List5, 
                         Number_Of_Exemptions_List1, Number_Of_Exemptions_List2, Number_Of_Exemptions_List3, Number_Of_Exemptions_List4, Number_Of_Exemptions_List5, Tax_Add_List1, Tax_Add_List2, Tax_Add_List3, 
                         Tax_Add_List4, Tax_Add_List5, Tax_Amount_Control_List1, Tax_Amount_Control_List2, Tax_Amount_Control_List3, Tax_Amount_Control_List4, Tax_Amount_Control_List5, Delete_Flag, Employment_Status, 
                         Minimum_Earnings, Number_Of_Dependents, Worker_Comp_Code, Department_Code, Selected_Flag, Months_To_Next_Review, Emergency_Contact, Emergency_Phone, Emergency_Relationship, Hours_List1, 
                         Hours_List2, Hours_List3, Standard_Work_Hours, Union_Code, Total_Hours, Check_Type, Manual_Check_Number, OT_Hours, Domicile_Address, Domicile_City, Domicile_State, Domicile_Zip_Code, 
                         Pay_Rate_Code, Employee_Work_Class, Wage_Class, Certified_Flag, Billing_Code, I9_Flag, I9_Expire_Date, EEO_Class_Code, Stop_Tax_Flag_List1, Stop_Tax_Flag_List2, Stop_Tax_Flag_List3, 
                         Stop_Tax_Flag_List4, Auto_Deposit_Flag, Burden_Percent, Prevail_Wage_Fringe_Rate, Pay_Rate_Percent, First_Name, Middle_Name, Last_Name, Occupation, Trade, Street_Address2, Domicile_Address2, 
                         Effective_Date, Comments, Cost_Center, Emp_Foreign, Perm_Work_Comp, Contact_ID, Permanent_Unemployment_State, Wrk_Mobile_ID, Wrk_Ext_ID
FROM            dbo.daily_report_employee_master_1 AS daily_report_employee_master_1_1 WITH (NOLOCK)
ORDER BY Employee_Name
' 
GO
/****** Object:  View [dbo].[daily_report_Employee2]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_Employee2]'))
EXEC dbo.sp_executesql @statement = N'CREATE
--DROP
 VIEW [dbo].[daily_report_Employee2]
AS
SELECT        TOP (100) PERCENT A.Company_Code, LTRIM(RTRIM(A.Employee_Code)) AS Employee_Code, A.Vacation_Hours_Balance_List1, B.Employee_Name, B.Employment_Status, A.Sick_Hours_Balance_List1
FROM             daily_report_employee_master AS A WITH (NOLOCK)
RIGHT OUTER JOIN daily_report_employee as B ON LTRIM(RTRIM(A.Employee_Code)) = B.Employee_Code
WHERE        (A.Company_Code = ''CE1'' and B.Company_Code = ''CE1'')
ORDER BY Employee_Code





' 
GO
/****** Object:  View [dbo].[daily_report_jobs]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_jobs]'))
EXEC dbo.sp_executesql @statement = N'




CREATE  VIEW [dbo].[daily_report_jobs]
AS
SELECT        daily_report_job_master_1.Company_Code, LTRIM(RTRIM(daily_report_job_master_1.Job_Number)) AS Job_Number, Master_Job, Division, LTRIM(RTRIM(daily_report_job_master_1.Job_Description)) AS Job_Description, RTRIM(LTRIM(Address_1)) AS Address_1, RTRIM(LTRIM(Address_2)) AS Address_2, RTRIM(LTRIM(City)) AS City , RTRIM(LTRIM(State)) AS State, RTRIM(LTRIM(Zip_Code)) AS Zip_Code, Phone, Superintendent, 
                         Estimator, Certified_Flag, Contract_Number, Status_Code, Total_Units, Unit_of_Measure, daily_report_job_master_1.Complete_Date, daily_report_job_master_1.Start_Date, Est_Complete_Date, Est_Start_Date, Payroll_OH_Percent, OH_Phase, OH_Cost_Type, 
						 Customer_Code, Index_Variable, Index_Variable_2, Burden_Flag, Burden_Percent, Burden_Phase, Burden_Cost_Type, Job_Type, Entered_Projected_Cost, daily_report_job_master_1.Original_Contract, Sales_Tax_Code, Job_Site_Phone, 
                         Entered_Percent_Complete, Taxable_Flag, Wage_Rate_Level, Work_Comp_Code, Price_Method_Code, Pre_TC_Burden_Percent, Phase_Display_Code, Major_Group_Start, Major_Group_End, Minor_Group_Start, 
                         Minor_Group_End, Fax_Phone, PR_OH_Type_Code, PR_OH_Amount, Job_Oh_Batch_Code, Wage_Code_Indicator, Work_State_Tax_Code, Work_County_Tax_Code, Work_Local_Tax_Code, Pay_Group, 
                         daily_report_job_master_1.Project_Manager, Earned_Calc_Type, Under_Billed, Cost_Markup_Percent, Tax_Class_Code, Auto_Ot_Flag, Ot_Over_Hrs, Dt_Over_Hrs, Period_Flag, Routing_Code1, Routing_Code2, Routing_Limit, 
                         Standard_Phase_Category, Track_Prevailing_Wage, Track_Davis_Bacon, Cost_Center, Projected_Complete_Date, Latitude, Longitude, Create_Date, WO_Site, Comment, Certified_Project_ID, 
                         Certified_Week_Type, Lock_Revenue_Entry
FROM            daily_report_job_master AS daily_report_job_master_1 WITH (NOLOCK)
' 
GO
/****** Object:  View [dbo].[daily_report_payroll_export_V2]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_payroll_export_V2]'))
EXEC dbo.sp_executesql @statement = N'











CREATE
--drop
 VIEW [dbo].[daily_report_payroll_export_V2] AS
SELECT
      D1.[dr_create_date]
      ,D1.[dr_create_time]
      ,D1.[dr_foreman]
      ,D1.[dr_status]
  
      ,cast(D1.[dr_create_date] AS varchar(10)) + '' '' + cast(D1.[dr_create_time] AS varchar(8)) + '' '' + D1.[dr_foreman_id] AS [batch]
      ,H1.hrs_employee_id AS [employee_code]
      ,CASE
	  WHEN H1.hrs_phase_code_type = ''P'' THEN ''531''
	  WHEN H1.hrs_phase_code_type = ''L'' THEN E1.empl_department
	  WHEN H1.hrs_phase_code_type = ''V'' THEN ''541''
	  ELSE ''511''
	  END AS [department]
      ,''R'' as [pay_type]
      ,H1.[hrs_hours]
      ,D1.[dr_job_no]
      ,H1.[hrs_phase_code]
      ,H1.[hrs_phase_code_type]
      ,D1.[dr_shift_date]
      ,CONVERT(nvarchar(50),D1.dr_approve_date) as [message_line]
      ,'''' as [pay_rate_level]
      ,'''' as [wage_code]
      ,'''' as [pay_group_code]
      ,'''' as [workers_group]
      ,'''' as [state_tax_code]
      ,'''' as [county_tax_code]
      ,'''' as [local_tax_code]
      ,'''' as [equipment_code]
      ,'''' as [equipment_hours]
      ,'''' as [quantity]
      ,E1.empl_company as [company_code]
      ,'''' as [pay_rate]
      ,'''' as [equipment_cost_category]
      ,'''' as [crew_code]
      ,'''' as [cost_center]
      ,'''' as [work_order]
      ,'''' as [site_equiment]
      ,'''' as [site_component]
      ,'''' as [contract]
      ,'''' as [equipment_work_order]
      ,D1.[dr_id]
      ,H1.hrs_employee AS [employee_name]
 FROM [dbo].[daily_report_hours_2] as H1
LEFT OUTER JOIN [dbo].[daily_report_2] AS D1
ON D1.dr_id = H1.[hrs_dr_id]
left join daily_report_employee_2 AS E1
 ON empl_dr_id = hrs_dr_id AND empl_name_id = hrs_employee_id
WHERE  D1.[dr_status] = ''3'' and H1.hrs_hours <> 0







' 
GO
/****** Object:  View [dbo].[daily_report_phase_code]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_phase_code]'))
EXEC dbo.sp_executesql @statement = N'





CREATE 
--drop
VIEW [dbo].[daily_report_phase_code]
AS
SELECT [Company_Code]
      ,LTRIM(RTRIM(Job_Number)) AS [Job_Number]
      ,LTRIM(RTRIM(Phase_Code)) AS [Phase_Code]
      ,LTRIM(RTRIM([Cost_Type])) AS [Cost_Type]
      ,LTRIM(RTRIM([Description])) AS [Description]
      ,[Status_Code]
      ,[Complete_Date]
      ,[Unit_of_Measure]
      ,[Major_Group_Code]
      ,[Minor_Group_Code]
      ,[Start_Date]
      ,[End_Date]
      ,[Lead_Time_Days]
      ,[Original_Est_Quantity]
      ,[Original_Est_Cost]
      ,[Original_Est_Hours]
      ,[Last_Cost_Date]
      ,[Work_Comp_Code]
      ,[TM_Markup_Flag]
      ,[Est_Unit_Cost]
      ,[Bid_Item_Number]
      ,[Alt_Phase_Code]
      ,[Price_Method_Code]
      ,[Projected_Cost_Code]
      ,[Work_State_Tax_Code]
      ,[Work_County_Tax_Code]
      ,[Work_Local_Tax_Code]
      ,[Last_Payroll_Date]
      ,[Certified_Flag]
      ,[Wage_Rate_Level]
      ,[Wage_Code_Indicator]
      ,[Phase_Cost_Center]
      ,[Update_Proj_Qty]
      ,[Comment]
	  ,SUBSTRING(Phase_Code,1,2) AS dr_area
	  ,SUBSTRING(PHASE_CODE,3,4) AS dr_phase
	  ,(Company_Code + RTRIM(LTRIM(Job_Number)) + RTRIM(LTRIM(Phase_Code)) + Cost_Type) AS lookup_field

FROM         daily_report_phase_master WITH (NOLOCK)

' 
GO
/****** Object:  View [dbo].[daily_report_phase_hours]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_phase_hours]'))
EXEC dbo.sp_executesql @statement = N'





CREATE VIEW [dbo].[daily_report_phase_hours]
AS
WITH source1 as
(
--Pulls from each daily report and lists the job phase, and the sum of hours assigned to the phase for that daily report
--Only uses daily reports that have been submitted and not rejected, and the shift date must be since the most recent monday
	SELECT		a.dr_job_no as job_no,
				b.hrs_phase_code as phase_code,
				b.hrs_phase_code_type as cost_type,
				SUM(b.hrs_hours) as hours
	FROM		daily_report_2 AS a INNER JOIN
				daily_report_hours_2 AS b ON a.dr_id = b.hrs_dr_id
	WHERE		(a.dr_shift_date >= DATEADD(wk, DATEDIFF(wk, 0, GETDATE()), 0)) AND b.hrs_phase_code <> '''' AND a.dr_status = ''3''
	GROUP BY	a.dr_job_no, b.hrs_phase_code, b.hrs_phase_code_type
)
SELECT			
--Pulls from source one and groups all hours together for each phase so that it is no longer distinguishing which daily report the hours come from
				job_no, 
				phase_code, 
				cost_type, 
				sum(hours) as hours
FROM			source1
GROUP BY		job_no, phase_code, cost_type




' 
GO
/****** Object:  View [dbo].[daily_report_v2_phases]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_v2_phases]'))
EXEC dbo.sp_executesql @statement = N'




CREATE 
--drop
VIEW [dbo].[daily_report_v2_phases] AS 
with thisQuery as
(
SELECT hrs_dr_id, hrs_phase_code, hrs_phase_code_type, hrs_phase_description, SUM(hrs_hours) AS Hours
From daily_report_hours_2
group by hrs_phase_code, hrs_dr_id, hrs_phase_code_type, hrs_phase_description),
otherQuery as
(
Select log_phase_code, log_dr_id,  Count(log_id) AS prod_log_num from daily_report_project_log where log_type = ''Prod''
group by log_phase_code, log_dr_id
)
Select hrs_dr_id, hrs_phase_code, hrs_phase_code_type, hrs_phase_description, Hours, ISNULL(prod_log_num,0) as prod_log_num from thisQuery
left join otherQuery ON hrs_dr_id = log_dr_id and hrs_phase_code = log_phase_code




' 
GO
/****** Object:  StoredProcedure [dbo].[daily_report_add_employee_V2]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_add_employee_V2]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[daily_report_add_employee_V2] AS' 
END
GO













-- =============================================
-- Author:		<Nathaniel Unruh>
-- Create date: <11/17/17>
-- Description:	<Adds an employee to the daily report (V2)>
-- =============================================
ALTER PROCEDURE [dbo].[daily_report_add_employee_V2]
	-- Add the parameters for the stored procedure here
	@p_empl_id		nvarchar(11),
	@p_dr_id		int,
	@p_name			nvarchar(50),
	@p_total_hrs	decimal(5,1),
	@p_company		nvarchar(50),
	@p_department	nvarchar(50),
	@p_user			nvarchar(50),
	@p_notes		nvarchar(500),
	@p_errors      nvarchar(2048) out

	AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    declare @w_errors nvarchar(2000) = ''
	declare @duplicate_empl int = (SELECT COUNT(empl_id) from daily_report_employee_2 where empl_dr_id = @p_dr_id and empl_name_id = @p_empl_id)

	
	if (@p_empl_id = '' or @p_empl_id IS NULL) begin
		set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter an employee.</Text></Message>'
	end
	--if (@p_total_hrs = 0) begin
	--	set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter hours.</Text></Message>'
	--end
	if(@p_total_hrs > 15) begin
		set @w_errors = @w_errors + '<Message type=''error''><Text>You cannot add more than 15 hours for one day.</Text></Message>'
	end
	if (@duplicate_empl <> 0) begin
		set @w_errors = @w_errors + '<Message type=''error''><Text>This employee was already added to this daily report</Text></Message>'
	end


	--values entered all looks good. Now check the logic
	--checks the hours the employee has across every daily report for this shift date
	if(@w_errors = '') begin
		--grab the shift date from the daily report
		declare @w_shift_date date;
		Select @w_shift_date =
		((Select dr_shift_date 
		from daily_report_2 where dr_id = @p_dr_id))

		--create a temp  table results that holds the sum of hours for each employee by day

		Create Table #Results
		(
			code nvarchar(50),
			foreman nvarchar(50),
			shift_date date,
			total_hrs decimal(5,1)
		)
		INSERT INTO #Results (code,foreman,shift_date,total_hrs)
		(Select t1.empl_name_id,MAX(dr_foreman),t2.dr_shift_date,SUM(t1.empl_hours) AS Sum_Hours from
			((SELECT empl_id
				  ,empl_dr_id
				  ,empl_name_id
				  ,empl_name
				  ,empl_hours
			 FROM [daily_report_employee_2]
			 WHERE empl_hours IS NOT NULL) AS t1
			 left join
			 (Select dr_shift_date,dr_id,dr_foreman from daily_report_2 where dr_id <> @p_dr_id) t2
			  on t2.dr_id = t1.empl_dr_id)

		  group by t1.empl_name_id,t2.dr_shift_date)

		  --if the hours for one guy for a day add up to over 15 then send an error
		  if((Select count(foreman) from #Results where code = @p_empl_id and shift_date = @w_shift_date) > 0)
		  BEGIN
			  --grab who entered in hours for the guy
			  declare @w_quick_foreman nvarchar(50) = 
			  (Select TOP 1 foreman from #Results where  code = @p_empl_id and shift_date = @w_shift_date)

			  --grab how many hours are entered in for the guy
			  declare @w_hrs_check int =
			  (Select TOP 1 total_hrs from #Results where code = @p_empl_id and shift_date = @w_shift_date)

				--if the old hours + new hours > 15 then throw an error
				 if(@w_hrs_check + @p_total_hrs > 15)
				 begin
					set @w_errors = @w_errors + '<Message type=''error''><Text>The foreman ' + @w_quick_foreman + ' has already entered in ' + CONVERT(nvarchar(50),@w_hrs_check) + ' hours for this employee for this shift date. </Text></Message>'
				 end 
		  END
	
	end

	  
	--if everything looks good...
	if (@w_errors = '' ) begin
	--update the hours
	INSERT INTO daily_report_employee_2
		(
		empl_dr_id,
		empl_name,
		empl_name_id,
		empl_hours,
		empl_hours_to_go,
		empl_datetime_added,
		empl_added_by,
		empl_department,
		empl_company,
		empl_notes
		)
	Values
		(
		@p_dr_id,
		@p_name,
		@p_empl_id,
		@p_total_hrs,
		@p_total_hrs,
		GETDATE(),
		@p_user,
		@p_department,
		@p_company,
		@p_notes
		)
	--Update the total daily hours for the report
	UPDATE daily_report_2
	SET dr_total_daily_hours = (SELECT SUM(empl_hours) from daily_report_employee_2 where empl_dr_id = @p_dr_id),
		dr_empl_number = (SELECT COUNT(empl_dr_id) from daily_report_employee_2 where empl_dr_id = @p_dr_id)
	where dr_id = @p_dr_id

		set @p_errors = null;
	end else begin 
		set @p_errors = '<Response>' + @w_errors + '</Response>';
	end 


END








GO
/****** Object:  StoredProcedure [dbo].[daily_report_add_hours]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_add_hours]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[daily_report_add_hours] AS' 
END
GO












-- =============================================
-- Author:		<Nathaniel Unruh>
-- Create date: <11/20/17>
-- Description:	<Adds hours to an employee to the daily report (V2)>
-- =============================================
ALTER PROCEDURE [dbo].[daily_report_add_hours]
	-- Add the parameters for the stored procedure here
	@p_empl_name		nvarchar(50),
	@p_empl_id			nvarchar(50),
	@p_dr_id			int,
	@p_hrs				decimal(5,1),
	@p_phase			nvarchar(50),
	@p_phase_type		nvarchar(50),
	@p_phase_descrip	nvarchar(50),
	@p_remem_pc			bit,
	@p_remem_empl		bit,
	@p_errors			nvarchar(2048) out

	AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    declare @w_errors nvarchar(2000) = ''
	--grab how many hours the guy has left to go.
	
	declare @hours_to_go_employee decimal(5,1);
	if(@p_hrs < 0) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter a positive number in for the hours.</Text></Message>'
	end
	if(@p_hrs = 0 or @p_hrs IS NULL) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter hours.</Text></Message>'
	end
	if(@p_phase IS NULL or @p_phase = '') begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter a phase code.</Text></Message>'
	end
	if(@p_empl_id IS NULL or @p_empl_id = '') begin
		set @w_errors = @w_errors + '<Message type=''error''><Text>Please select an employee.</Text></Message>'
	end
	else begin
		SET @hours_to_go_employee = (SELECT empl_hours_to_go from daily_report_employee_2 where empl_dr_id = @p_dr_id and empl_name_id = @p_empl_id)
	end
	if (@w_errors = '' ) begin

		if(@hours_to_go_employee < @p_hrs) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>The Employee only has ' + CONVERT(nvarchar(50),@hours_to_go_employee) + ' hours left to spread.</Text></Message>'
		end
	end

	--if everything looks good...
	if (@w_errors = '' ) begin

	--variables used for hours calculations
	declare @hours_already_added decimal(5,1) = (SELECT SUM(hrs_hours) from daily_report_hours_2 where hrs_dr_id = @p_dr_id and hrs_employee_id = @p_empl_id)
	declare @all_hours_spread bit;
	declare @hours_to_go_after_add decimal(5,1) = ISNULL(@hours_to_go_employee,0) - @p_hrs;

	--check if all the hours were spread
	if( @hours_to_go_after_add = 0) begin
		SET @all_hours_spread = 1;
	end 
	else begin
		SET @all_hours_spread = 0;
	end

	Insert into daily_report_hours_2
	(
		hrs_dr_id,
		hrs_hours,
		hrs_employee,
		hrs_employee_id,
		hrs_phase_code,
		hrs_phase_code_type,
		hrs_phase_description,
		hrs_daily_hours_reached
	)
	Values
	(
		@p_dr_id,
		@p_hrs,
		@p_empl_name,
		@p_empl_id,
		@p_phase,
		@p_phase_type,
		@p_phase_descrip,
		@all_hours_spread
	)

	--update the other hours lines with whether or not the hours have been spread out correctly
	Update daily_report_hours_2
	SET hrs_daily_hours_reached = @all_hours_spread
	WHERE hrs_dr_id = @p_dr_id and hrs_employee_id = @p_empl_id

	--update the hours to go in the employee table
	Update daily_report_employee_2
	SET empl_hours_to_go = @hours_to_go_after_add
	WHERE empl_dr_id = @p_dr_id and empl_name_id = @p_empl_id

	--remember phase codes and employees if user wants you to

	if(@p_remem_empl = 1 and @p_remem_pc = 1)
	begin 
		SET @P_errors = 
			'<Response>
				<SetSessionProperty>
					<SessionProperty name= ''S_daily_log_pc''><Value><![CDATA[' + @p_phase + ']]></Value>
					</SessionProperty>
					<SessionProperty name= ''S_daily_log_pc_type''><Value><![CDATA[' + @p_phase_type + ']]></Value>
					</SessionProperty>
					<SessionProperty name= ''S_daily_log_pc_descrip''><Value><![CDATA[' + @p_phase_descrip + ']]></Value>
					</SessionProperty>
					<SessionProperty name= ''S_daily_log_empl''><Value><![CDATA[' + @p_empl_name + ']]></Value>
					</SessionProperty>
					<SessionProperty name= ''S_daily_log_empl_id''><Value><![CDATA[' + @p_empl_id + ']]></Value>
					</SessionProperty>
					<SessionProperty name= ''S_daily_log_empl_hrs_to_go''><Value><![CDATA[' + CONVERT(nvarchar(50),@hours_to_go_after_add) + ']]></Value>
					</SessionProperty>
				</SetSessionProperty>
			</Response>';
	end
	else if(@p_remem_pc = 1)
	begin
		SET @P_errors = 
			'<Response>
				<SetSessionProperty>
					<SessionProperty name= ''S_daily_log_pc''><Value><![CDATA[' + @p_phase + ']]></Value>
					</SessionProperty>
					<SessionProperty name= ''S_daily_log_pc_type''><Value><![CDATA[' + @p_phase_type + ']]></Value>
					</SessionProperty>
					<SessionProperty name= ''S_daily_log_pc_descrip''><Value><![CDATA[' + @p_phase_descrip + ']]></Value>
					</SessionProperty>
					<SessionProperty name= ''S_daily_log_empl''><Value></Value>
					</SessionProperty>
					<SessionProperty name= ''S_daily_log_empl_id''><Value></Value>
					</SessionProperty>
					<SessionProperty name= ''S_daily_log_empl_hrs_to_go''><Value>''</Value>
					</SessionProperty>
				</SetSessionProperty>
			</Response>';
	end
	else if(@p_remem_empl = 1)
	begin
		SET @P_errors = 
			'<Response>
				<SetSessionProperty>
					<SessionProperty name= ''S_daily_log_pc''><Value></Value>
					</SessionProperty>
					<SessionProperty name= ''S_daily_log_pc_type''><Value></Value>
					</SessionProperty>
					<SessionProperty name= ''S_daily_log_pc_descrip''><Value></Value>
					</SessionProperty>
					<SessionProperty name= ''S_daily_log_empl''><Value><![CDATA[' + @p_empl_name + ']]></Value>
					</SessionProperty>
					<SessionProperty name= ''S_daily_log_empl_id''><Value><![CDATA[' + @p_empl_id + ']]></Value>
					</SessionProperty>
					<SessionProperty name= ''S_daily_log_empl_hrs_to_go''><Value><![CDATA[' + CONVERT(nvarchar(50),@hours_to_go_after_add) + ']]></Value>
					</SessionProperty>
				</SetSessionProperty>
			</Response>';
	end
	--if remembering the pc or empl is 0 then just send the errors to null
	else
	begin
		SET @P_errors = 
			'<Response>
					<SetSessionProperty>
						<SessionProperty name= ''S_daily_log_pc''><Value></Value>
						</SessionProperty>
						<SessionProperty name= ''S_daily_log_pc_type''><Value></Value>
						</SessionProperty>
						<SessionProperty name= ''S_daily_log_pc_descrip''><Value></Value>
						</SessionProperty>
						<SessionProperty name= ''S_daily_log_empl''><Value></Value>
						</SessionProperty>
						<SessionProperty name= ''S_daily_log_empl_id''><Value></Value>
						</SessionProperty>
						<SessionProperty name= ''S_daily_log_empl_hrs_to_go''><Value>''</Value>
						</SessionProperty>
					</SetSessionProperty>
				</Response>';
	end

	end else begin 
		set @p_errors = '<Response>' + @w_errors + '</Response>';
	end 


END








GO
/****** Object:  StoredProcedure [dbo].[daily_report_approve_V2]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_approve_V2]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[daily_report_approve_V2] AS' 
END
GO



-- =============================================
-- Author:		<Nathaniel Unruh>
-- Create date: <1/2/18>
-- Description:	<Approve a daily report (V2)>
-- =============================================
ALTER PROCEDURE [dbo].[daily_report_approve_V2]
	-- Add the parameters for the stored procedure here
	@p_dr_id			int,
	@p_user				nvarchar(50),
	@p_user_id			nvarchar(50),
	@p_errors			nvarchar(2048) out

	AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    declare @w_errors nvarchar(2000) = '';
	declare @w_status nvarchar(50);
	
	--grab the status

	Select @w_status = dr_status from daily_report_2
	where dr_id = @p_dr_id

	if(@w_status <> 2) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>You can only approve a daily report after it has been submitted.</Text></Message>'
	end


	--if everything looks good...
	if (@w_errors = '' ) begin

	--set the status to approved
	Update daily_report_2
		SET 
			dr_status = 3,
			dr_approve_date = GETDATE(),
			dr_approve_time = GETDATE(),
			dr_approve_datetime = GETDATE(),
			dr_approver = @p_user,
			dr_approver_userid = @p_user_id
	WHERE dr_id = @p_dr_id

		set @p_errors = null;
	end else begin 
		set @p_errors = '<Response>' + @w_errors + '</Response>';
	end 


END








GO
/****** Object:  StoredProcedure [dbo].[daily_report_delete_card_V2]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_delete_card_V2]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[daily_report_delete_card_V2] AS' 
END
GO





-- =============================================
-- Author:		<Nathaniel Unruh>
-- Create date: <6/26/2018>
-- Description:	<Upon deletion of a daily report, all hours and employees are deleted along with it>
-- =============================================
ALTER PROCEDURE [dbo].[daily_report_delete_card_V2]
	-- Add the parameters for the stored procedure here
	@p_dr_id		int,
	@p_errors		nvarchar(2048) out

AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    DECLARE @w_errors nvarchar(2000) = ''
	if(@p_dr_id IS NULL or @p_dr_id = 0)
	begin
		set @w_errors = @w_errors + '<Message type=''error''><Text>Dr ID is required</Text></Message>'
	end

	IF (@w_errors = '' ) BEGIN
		--deletes all hours associated with the daily report
		DELETE FROM daily_report_hours_2
		WHERE hrs_dr_id = @p_dr_id

		--deletes all employees associated with the daily report
		DELETE FROM daily_report_employee_2
		WHERE empl_dr_id = @p_dr_id
		
		--delete all project logs associated with the daily report
		DELETE FROM daily_report_project_log
		WHERE log_dr_id = @p_dr_id

		--delete the actual daily report
		DELETE FROM daily_report_2
		WHERE dr_id = @p_dr_id

		-- sets the errors to null
		SET @p_errors = null;
	END ELSE BEGIN
		SET @p_errors = '<Response>' + @w_errors + '</Response>';
	END 
END


GO
/****** Object:  StoredProcedure [dbo].[daily_report_delete_employee_V2]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_delete_employee_V2]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[daily_report_delete_employee_V2] AS' 
END
GO






-- =============================================
-- Author:		<Nathaniel Unruh>
-- Create date: <11/21/17>
-- Description:	<Deletes hours from a daily report (V2)>
-- =============================================
ALTER PROCEDURE [dbo].[daily_report_delete_employee_V2]
	-- Add the parameters for the stored procedure here
	@p_id				int,
	@p_dr_id			int,
	@p_errors			nvarchar(2048) out

	AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    declare @w_errors nvarchar(2000) = '';

	--if everything looks good...
	if (@w_errors = '' ) begin

	declare @w_empl_id nvarchar(50);
	
	Select @w_empl_id = empl_name_id
	from daily_report_employee_2 where empl_id = @p_id

	--delete the employee
	DELETE daily_report_employee_2
	WHERE empl_id = @p_id


	--update the total hours in the daily report
	UPDATE daily_report_2
	SET dr_total_daily_hours = (SELECT SUM(empl_hours) from daily_report_employee_2 where empl_dr_id = @p_dr_id),
	dr_empl_number = (SELECT COUNT(empl_dr_id) from daily_report_employee_2 where empl_dr_id = @p_dr_id)
	where dr_id = @p_dr_id

	--delete all the hours added in for the employee for that daily report
	DELETE from daily_report_hours_2 where hrs_employee_id = @w_empl_id and hrs_dr_id = @p_dr_id

		set @p_errors = null;
	end else begin 
		set @p_errors = '<Response>' + @w_errors + '</Response>';
	end 


END








GO
/****** Object:  StoredProcedure [dbo].[daily_report_delete_hours]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_delete_hours]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[daily_report_delete_hours] AS' 
END
GO












-- =============================================
-- Author:		<Nathaniel Unruh>
-- Create date: <11/21/17>
-- Description:	<Deletes hours from a daily report (V2)>
-- =============================================
ALTER PROCEDURE [dbo].[daily_report_delete_hours]
	-- Add the parameters for the stored procedure here
	@p_id				int,
	@p_dr_id			int,
	@p_errors			nvarchar(2048) out

	AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    declare @w_errors nvarchar(2000) = ''
	declare @w_hours decimal(5,1), @w_empl_id nvarchar(50);
	
	Select @w_hours = hrs_hours, @w_empl_id = hrs_employee_id
	from daily_report_hours_2 where hrs_id = @p_id

	

	--if everything looks good...
	if (@w_errors = '' ) begin


	--delete the line
	DELETE daily_report_hours_2
	WHERE hrs_id = @p_id

	--calculate how many hours are left
	declare @hours_to_go_after_delete decimal(5,1) = (Select SUM(hrs_hours) from daily_report_hours_2 where hrs_employee_id = @w_empl_id and hrs_dr_id = @p_dr_id)
	
	--update the hours to go in the employee table
	Update daily_report_employee_2
	SET empl_hours_to_go = empl_hours - ISNULL(@hours_to_go_after_delete,0)
	WHERE empl_dr_id = @p_dr_id and empl_name_id = @w_empl_id

		set @p_errors = null;
	end else begin 
		set @p_errors = '<Response>' + @w_errors + '</Response>';
	end 


END








GO
/****** Object:  StoredProcedure [dbo].[daily_report_edit_employee_V2]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_edit_employee_V2]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[daily_report_edit_employee_V2] AS' 
END
GO












-- =============================================
-- Author:		<Nathaniel Unruh>
-- Create date: <11/17/17>
-- Description:	<Edits an employee added to the daily report (V2)>
-- =============================================
ALTER PROCEDURE [dbo].[daily_report_edit_employee_V2]
	-- Add the parameters for the stored procedure here
	@p_old_empl_id nvarchar(50),
	@p_old_empl_name nvarchar(50),
	@p_old_hours	decimal(5,1),
	@p_id			int, -- tableID of the DR employee
	@p_empl_id		nvarchar(50),
	@p_dr_id		int,
	@p_name			nvarchar(50),
	@p_total_hrs	decimal(5,1),
	@p_company		nvarchar(50),
	@p_department	nvarchar(50),
	@p_user			nvarchar(50),
	@p_notes		nvarchar(1000),
	@p_errors      nvarchar(2048) out

	AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    DECLARE @w_errors nvarchar(2000) = ''
	DECLARE @duplicate_empl int = (SELECT COUNT(empl_id) from daily_report_employee_2 where empl_dr_id = @p_dr_id and empl_name_id = @p_empl_id and empl_id <> @p_id)
	--DECLARE @hours_added_on_daily int = (SELECT COUNT(hrs_hours) from daily_hours_2 where hrs_dr_id = @p_dr_id and hrs_employee_id = @p_empl_id) -- checks if hours were already added for this employee and they are trying to pull a fast one.
	
	if (@p_empl_id = '' or @p_empl_id IS NULL) begin
		set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter an employee.</Text></Message>'
	end
	if (@p_total_hrs = 0) begin
		set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter hours.</Text></Message>'
	end

	IF(@p_total_hrs > 15) BEGIN
		set @w_errors = @w_errors + '<Message type=''error''><Text>You cannot add more than 15 hours for one day.</Text></Message>'
	END

	IF (@duplicate_empl <> 0) BEGIN
		SET @w_errors = @w_errors + '<Message type=''error''><Text>This employee was already added to this daily report</Text></Message>'
	END

	--data entered looks good. Now check logic
	--checks if the employee had hours entered in across other daily reports
	if (@w_errors = '') begin
		--grab the shift date from the daily report
		declare @w_shift_date date;
		Select @w_shift_date =
		((Select dr_shift_date 
		from daily_report_2 where dr_id = @p_dr_id))

		--create a temp  table results that holds the sum of hours for each employee by day

		Create Table #Results
		(
			code nvarchar(50),
			foreman nvarchar(50),
			shift_date date,
			total_hrs decimal(5,1)
		)
		INSERT INTO #Results (code,foreman,shift_date,total_hrs)
		(Select t1.empl_name_id,MAX(dr_foreman),t2.dr_shift_date,SUM(t1.empl_hours) AS Sum_Hours from
			((SELECT empl_id
				  ,empl_dr_id
				  ,empl_name_id
				  ,empl_name
				  ,empl_hours
			 FROM [daily_report_employee_2]
			 WHERE empl_hours IS NOT NULL and empl_id <> @p_id) AS t1
			 left join
			 (Select dr_shift_date,dr_id,dr_foreman from daily_report_2 where dr_id <> @p_dr_id) t2
			  on t2.dr_id = t1.empl_dr_id)

		  group by t1.empl_name_id,t2.dr_shift_date)

		  --if the hours for one guy for a day add up to over 15 then send an error
		  if((Select count(foreman) from #Results where code = @p_empl_id and shift_date = @w_shift_date) > 0)
		  BEGIN
			  --grab who entered in hours for the guy
			  declare @w_quick_foreman nvarchar(50) = 
			  (Select TOP 1 foreman from #Results where  code = @p_empl_id and shift_date = @w_shift_date)

			  --grab how many hours are entered in for the guy
			  declare @w_hrs_check int =
			  (Select TOP 1 total_hrs from #Results where code = @p_empl_id and shift_date = @w_shift_date)

				--if the old hours + new hours > 15 then throw an error
				 if(@w_hrs_check + @p_total_hrs > 15)
				 begin
					set @w_errors = @w_errors + '<Message type=''error''><Text>The foreman ' + @w_quick_foreman + ' has already entered in ' + CONVERT(nvarchar(50),@w_hrs_check) + ' hours for this employee for this shift date. </Text></Message>'
				 end 
		  END
		   IF OBJECT_ID('tempdb..#Results') IS NOT NULL DROP TABLE #Results
	end
	

	  
	--if everything looks good...
	if (@w_errors = '' ) begin
	--update the hours
	if(@p_old_empl_id <> @p_empl_id or @p_old_empl_name <> @p_name or @p_old_hours <> @p_total_hrs)
	begin
		Update  daily_report_employee_2
		SET
			empl_name = @p_name,
			empl_name_id = @p_empl_id,
			empl_hours = @p_total_hrs,
			empl_hours_to_go = @p_total_hrs,
			empl_datetime_added = getDate(),
			empl_added_by = @p_user,
			empl_department = @p_department,
			empl_company = @p_company,
			empl_notes = @p_notes,
			empl_sick = 0
		where empl_id = @p_id

		-- delete out all spread hours for the employee that was changed for that daily report.
		DELETE from daily_report_hours_2 where hrs_employee_id = @p_old_empl_id and hrs_dr_id = @p_dr_id
	end
	else
		begin
		Update  daily_report_employee_2
			SET
				empl_datetime_added = getDate(),
				empl_added_by = @p_user,
				empl_notes = @p_notes
			where empl_id = @p_id
		end

	--Update the total daily hours for the report
	UPDATE daily_report_2
	SET dr_total_daily_hours = (SELECT SUM(empl_hours) from daily_report_employee_2 where empl_dr_id = @p_dr_id),
		dr_empl_number = (SELECT COUNT(empl_dr_id) from daily_report_employee_2 where empl_dr_id = @p_dr_id)
	where dr_id = @p_dr_id

	--if nothing was changed, do nothing.
	set @p_errors = null;
	end else begin 
		set @p_errors = '<Response>' + @w_errors + '</Response>';
	end 


END








GO
/****** Object:  StoredProcedure [dbo].[daily_report_empl_absent]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_empl_absent]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[daily_report_empl_absent] AS' 
END
GO



-- =============================================
-- Author:		<Nathaniel Unruh>
-- Create date: <1/26/2018>
-- Description:	<Marks an employee on a daily report as absent for the day.>
-- =============================================
ALTER PROCEDURE [dbo].[daily_report_empl_absent]
	-- Add the parameters for the stored procedure here
	@p_empl_name_id		nvarchar(50),
	@p_empl_name		nvarchar(50),
	@p_empl_id			nvarchar(50), -- ID of the employee object
	@p_user_id			nvarchar(50),
	@p_notes			nvarchar(1000),
	@P_errors nvarchar(2048) out 
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	DECLARE @w_errors nvarchar(2048) = '';
	DECLARE @w_company nvarchar(50) = (Select empl_company from daily_report_employee_2 where empl_id = @p_empl_id);
	DECLARE @w_dr_id int = (Select empl_dr_id from daily_report_employee_2 where empl_id = @p_empl_id);

	DECLARE @w_pto_avail nvarchar(50);

	if(@w_company = 'CE1')
	begin
		Select @w_pto_avail = Vacation_Hours_Balance_List1
		from daily_report_employee_master where Employee_Code = @p_empl_name_id and Company_Code = 'CE1'
	end

    -- Insert statements for procedure here
	IF (@w_errors = '') BEGIN

	--mark employee as sick
	Update daily_report_employee_2
	 SET empl_sick = 1,
		 empl_hours = 0,
		 empl_hours_to_go = 0,
		 empl_datetime_added = getDate(),
		 empl_added_by = @p_user_id,
		 empl_notes = @p_notes
	where empl_id = @p_empl_id;

	--update the totals on the daily report
	UPDATE daily_report_2
	SET dr_total_daily_hours = (SELECT SUM(empl_hours) from daily_report_employee_2 where empl_dr_id = @w_dr_id),
		dr_empl_number = (SELECT COUNT(empl_dr_id) from daily_report_employee_2 where empl_dr_id = @w_dr_id)
	where dr_id = @w_dr_id

	--Delete out all added hours for this employee on this daily
	DELETE from daily_report_hours_2 where hrs_employee_id = @p_empl_name_id and hrs_dr_id = @w_dr_id
	
	if(@w_company = 'CE1')
	begin

	SET @P_errors = 
		'<Response>
		<Request>
			<SetSessionProperty>
			<SessionProperty name=''S_hr_empl_name_dash''>
			<Value>' + @p_empl_name +'</Value>
			</SessionProperty>
			<SessionProperty name=''S_hr_empl_code_dash''>
			<Value>' + @p_empl_name_id+ '</Value>
			</SessionProperty>
			<SessionProperty name=''S_hr_pto_avail_dash''>
			<Value>' + @w_pto_avail+ '</Value>
			</SessionProperty>
			</SetSessionProperty>
		</Request>
		</Response>'

	end
	else
	begin
		SET @P_errors = null
	END
	END ELSE BEGIN
		SET @P_errors = '<Response>' + @w_errors + '</Response>';
	END
END
GO
/****** Object:  StoredProcedure [dbo].[daily_report_project_log_add_daily]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_project_log_add_daily]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[daily_report_project_log_add_daily] AS' 
END
GO











-- =============================================
-- Author:		<Nathaniel Unruh>
-- Create date: <5/14/2018>
-- Description:	<Add a Project Log>
-- =============================================
ALTER PROCEDURE [dbo].[daily_report_project_log_add_daily]
	-- Add the parameters for the stored procedure here
	@p_type					nvarchar(50),
	@p_create_user			nvarchar(50),
	@p_dr_id				int,
	@p_phase_code			nvarchar(50),
	@p_description			nvarchar(2000),
	@p_caused_by			nvarchar(1000),
	@p_loss_time			decimal(6,1),
	@p_loss_hours			decimal(6,1),
	@p_loss_equipment		nvarchar(500),
	@p_cause				nvarchar(500),
	@p_from_time			time,
	@p_to_time				time,
	@p_visitor				nvarchar(500),
	@p_received_from		nvarchar(50),
	@p_authorized_by		nvarchar(50),
	@p_performed_by			nvarchar(50),
	@p_phase_code_sub		nvarchar(50),
	@p_phase_code_prod		nvarchar(50),
	--@p_incident_sum			nvarchar(50),
	@p_sub_lead				nvarchar(50),
	--@p_inspec_performed		nvarchar(500),
	@p_phase_type			nvarchar(50),
	@p_phase_description	nvarchar(50),
	@p_errors				nvarchar(2048) out

	AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    declare @w_errors nvarchar(2000) = ''

	--error checks for all types
	if(@p_type IS NULL or @p_type = '') begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>A type is required. Please contact Catavolt Support</Text></Message>'
	end
	if(@p_dr_id IS NULL or @p_dr_id = 0) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>This item must be created from a daily report.</Text></Message>'
	end

	--check phase code for each type except for incident and inspection
	if(@p_type != 'Incident' and @p_type != 'Inspection' and @p_type != 'Visitors')
		begin
		if(@p_phase_code IS NULL or @p_phase_code = '') begin
				set @w_errors = @w_errors + '<Message type=''error''><Text>A Phase Code is required.</Text></Message>'
		end
	end
	--error checks for specific ones depending on the type


	--Production
	if(@p_type = 'Prod')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please describe the work performed for the day.</Text></Message>'
		end
	end

	--Goal
	if(@p_type = 'Goal')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please describe the goal for the day.</Text></Message>'
		end
		if(CONVERT(DATE, SYSDATETIME()) > (SELECT dr_shift_date FROM daily_report_2 WHERE dr_id = @p_dr_id)
			or CONVERT(TIME, SYSDATETIME()) > DATEADD(HOUR, 2, (SELECT dr_shift_time_start FROM daily_report_2 WHERE dr_id = @p_dr_id))) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>A goal must be set within 2 hours of the shift start</Text></Message>'
		end
	end

	--Impact
	else if(@p_type = 'Impact')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter in a description of the impact.</Text></Message>'
		end
		--if(@p_caused_by IS NULL or @p_caused_by = '')
		--begin
		--	set @w_errors = @w_errors + '<Message type=''error''><Text>Please describe what the impact was caused by.</Text></Message>'
		--end
		if(@p_loss_time IS NULL or @p_loss_time = 0)
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter the number of hours schedule progress was lost</Text></Message>'
		end
		if(@p_loss_hours IS NULL or @p_loss_hours = 0)
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter the total number of man hours lost</Text></Message>'
		end

		--not required

		--if(@p_loss_equipment IS NULL or @p_loss_equipment = '')
		--begin
		--	set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter equipment lost</Text></Message>'
		--end
	end

	--Rework
	else if(@p_type = 'Rework')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter in a description of the rework.</Text></Message>'
		end
		if(@p_cause IS NULL or @p_cause = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please describe what the rework cause was.</Text></Message>'
		end
	end

	--QAQC
	else if(@p_type = 'QAQC')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter in a description for the QAQC.</Text></Message>'
		end
	end

	--Visitors
	else if(@p_type = 'Visitors')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter in the purpose of the visit.</Text></Message>'
		end
		if(@p_visitor IS NULL or @p_visitor = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please describe who the visitor was.</Text></Message>'
		end
		if(@p_from_time IS NULL or @p_from_time = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Enter in the arrival time of the visitor.</Text></Message>'
		end
		if(@p_to_time IS NULL or @p_to_time = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Enter in the departure time of the visitor.</Text></Message>'
		end
	end

	--Verbal
	else if(@p_type = 'Verbal')
	begin
		if(@p_received_from IS NULL or @p_received_from = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please state who provided the instruction.</Text></Message>'
		end
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter the direction provided</Text></Message>'
		end
	end

	--TM
	else if(@p_type = 'TM')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter what a description of the work performed</Text></Message>'
		end
		if(@p_authorized_by IS NULL or @p_authorized_by = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter who authorized </Text></Message>'
		end
	end
	
	--Survey
	else if(@p_type = 'Survey')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter a description of the work.</Text></Message>'
		end
		if(@p_performed_by IS NULL or @p_performed_by = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please describe who the survey was performed by.</Text></Message>'
		end
	end

	--Subcontractors
	else if(@p_type = 'Sub')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter a description of the work.</Text></Message>'
		end
		if(@p_sub_lead IS NULL or @p_sub_lead = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please specify who was the lead subcontractor </Text></Message>'
		end
	end

	--Safety Incident
	else if(@p_type = 'Incident')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please summarize the incident.</Text></Message>'
		end
	end

	--Safety Inspection
	else if(@p_type = 'Inspection')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please specify what inspection was performed.</Text></Message>'
		end
		if(@p_performed_by IS NULL or @p_performed_by = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please specify who the inspection was performed by.</Text></Message>'
		end
	end

	--if everything looks good...
	if (@w_errors = '' ) begin

	Insert into daily_report_project_log
	(
		log_dr_id,
		log_type,
		log_phase_code,
		log_description,
		log_caused_by,
		log_loss_time,
		log_loss_hours,
		log_loss_equipment,
		log_cause,
		log_from_time,
		log_to_time,
		log_received_from,
		log_authorized_by,
		log_performed_by,
		log_sub_lead,
		log_phase_type,
		log_phase_description,
		log_visitor,
		log_create_user,
		log_create_time,
		log_phase_code_sub,
		log_phase_code_prod,
		log_last_updated
	)
	Values
	(
		@p_dr_id,
		@p_type,
		@p_phase_code,
		@p_description,
		@p_caused_by,
		@p_loss_time,
		@p_loss_hours,
		@p_loss_equipment,
		@p_cause,
		@p_from_time,
		@p_to_time,
		@p_received_from,
		@p_authorized_by,
		@p_performed_by,
		@p_sub_lead,
		@p_phase_type,
		@p_phase_description,
		@p_visitor,
		@p_create_user,
		GETDATE(),
		@p_phase_code_sub,
		@p_phase_code_prod,
		GETDATE()
	)

		set @p_errors = null;
	end else begin 
		set @p_errors = '<Response>' + @w_errors + '</Response>';
	end 


END








GO
/****** Object:  StoredProcedure [dbo].[daily_report_project_log_edit_daily]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_project_log_edit_daily]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[daily_report_project_log_edit_daily] AS' 
END
GO




-- =============================================
-- Author:		<Nathaniel Unruh>
-- Create date: <5/14/2018>
-- Description:	<Edits a Project Log>
-- =============================================
ALTER PROCEDURE [dbo].[daily_report_project_log_edit_daily]
	-- Add the parameters for the stored procedure here
	@p_type					nvarchar(50),
	@p_create_user			nvarchar(50),
	@p_id					int, -- ID of the log being changed. Only different parameter from add SP (was dr_id)
	@p_phase_code			nvarchar(50),
	@p_description			nvarchar(2000),
	@p_caused_by			nvarchar(1000),
	@p_loss_time			decimal(6,1),
	@p_loss_hours			decimal(6,1),
	@p_loss_equipment		nvarchar(500),
	@p_cause				nvarchar(500),
	@p_from_time			time,
	@p_to_time				time,
	@p_visitor				nvarchar(500),
	@p_received_from		nvarchar(50),
	@p_authorized_by		nvarchar(50),
	@p_performed_by			nvarchar(50),
	@p_phase_code_sub		nvarchar(50),
	@p_phase_code_prod		nvarchar(50),
	--@p_incident_sum			nvarchar(50),
	@p_sub_lead				nvarchar(50),
	--@p_inspec_performed		nvarchar(500),
	@p_phase_type			nvarchar(50),
	@p_phase_description	nvarchar(50),
	@p_errors				nvarchar(2048) out

	AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    declare @w_errors nvarchar(2000) = ''
	DECLARE @w_shift_date_time datetime = CAST((SELECT dr_shift_date FROM daily_report_2 WHERE dr_id = (SELECT log_dr_id FROM daily_report_project_log where log_id = @p_id)) as datetime) + CAST((SELECT dr_shift_time_start FROM daily_report_2 WHERE dr_id = (SELECT log_dr_id FROM daily_report_project_log where log_id = @p_id)) as datetime)

	--error checks for all types
	if(@p_type IS NULL or @p_type = '') begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>A type is required. Please contact Catavolt Support</Text></Message>'
	end
	if(@p_id IS NULL or @p_id = 0) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>This item needs to exist</Text></Message>'
	end

	--check phase code for each type except for incident and inspection
	if(@p_type != 'Incident' or @p_type != 'Inspection')
		begin
		if(@p_phase_code IS NULL or @p_phase_code = '') begin
				set @w_errors = @w_errors + '<Message type=''error''><Text>A Phase Code is required.</Text></Message>'
		end
	end
	--error checks for specific ones depending on the type


	--Production
	if(@p_type = 'Prod')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please describe the work performed for the day.</Text></Message>'
		end
	end

	if(@p_type = 'Goal')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please describe the goal for the day.</Text></Message>'
		end
		IF (SYSDATETIME() >= @w_shift_date_time) BEGIN
			IF (DATEDIFF(minute, @w_shift_date_time, SYSDATETIME()) > 120) BEGIN
				set @w_errors = @w_errors + '<Message type=''error''><Text>A goal must be set within 2 hours of the shift start</Text></Message>'
			END
		END
	end

	--Impact
	else if(@p_type = 'Impact')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter in a description of the impact.</Text></Message>'
		end
		if(@p_caused_by IS NULL or @p_caused_by = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please describe what the impact was caused by.</Text></Message>'
		end
		if(@p_loss_time IS NULL or @p_loss_time = 0)
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter the time lost</Text></Message>'
		end
		if(@p_loss_hours IS NULL or @p_loss_hours = 0)
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter the hours lost</Text></Message>'
		end

		--not required

		--if(@p_loss_equipment IS NULL or @p_loss_equipment = '')
		--begin
		--	set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter equipment lost</Text></Message>'
		--end
	end

	--Rework
	else if(@p_type = 'Rework')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter in a description of the rework.</Text></Message>'
		end
		if(@p_cause IS NULL or @p_cause = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please describe what the rework cause was.</Text></Message>'
		end
	end

	--QAQC
	else if(@p_type = 'QAQC')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter in a description for the QAQC.</Text></Message>'
		end
	end

	--Visitors
	else if(@p_type = 'Visitors')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter in the purpose of the visit.</Text></Message>'
		end
		if(@p_visitor IS NULL or @p_visitor = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please describe who the visitor was.</Text></Message>'
		end
		if(@p_from_time IS NULL or @p_from_time = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Enter in the arrival time of the visitor.</Text></Message>'
		end
		if(@p_to_time IS NULL or @p_to_time = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Enter in the departure time of the visitor.</Text></Message>'
		end
	end

	--Verbal
	else if(@p_type = 'Verbal')
	begin
		if(@p_received_from IS NULL or @p_received_from = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please state who provided the instruction.</Text></Message>'
		end
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter the direction provided</Text></Message>'
		end
	end

	--TM
	else if(@p_type = 'TM')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter what a description of the work performed</Text></Message>'
		end
		if(@p_authorized_by IS NULL or @p_authorized_by = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter who authorized </Text></Message>'
		end
	end
	
	--Survey
	else if(@p_type = 'Survey')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter a description of the work.</Text></Message>'
		end
		if(@p_performed_by IS NULL or @p_performed_by = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please describe who the survey was performed by.</Text></Message>'
		end
	end

	--Subcontractors
	else if(@p_type = 'Sub')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter a description of the work.</Text></Message>'
		end
		if(@p_sub_lead IS NULL or @p_sub_lead = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please specify who was the lead subcontractor </Text></Message>'
		end
	end

	--Safety Incident
	else if(@p_type = 'Incident')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please summarize the incident.</Text></Message>'
		end
	end

	--Safety Inspection
	else if(@p_type = 'Inspection')
	begin
		if(@p_description IS NULL or @p_description = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please specify what inspection was performed.</Text></Message>'
		end
		if(@p_performed_by IS NULL or @p_performed_by = '')
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please specify who the inspection was performed by.</Text></Message>'
		end
	end

	--if everything looks good...
	if (@w_errors = '' ) begin

		Update daily_report_project_log
		SET 
			log_type = @p_type,
			log_phase_code = @p_phase_code,
			log_description = @p_description,
			log_caused_by = @p_caused_by,
			log_loss_time = @p_loss_time,
			log_loss_hours = @p_loss_hours,
			log_loss_equipment = @p_loss_equipment,
			log_cause = @p_cause,
			log_from_time = @p_from_time,
			log_to_time = @p_to_time,
			log_received_from = @p_received_from,
			log_authorized_by = @p_authorized_by,
			log_performed_by = @p_performed_by,
			log_sub_lead = @p_sub_lead,
			log_phase_type = @p_phase_type,
			log_phase_description = @p_phase_description,
			log_visitor = @p_visitor,
			log_phase_code_sub = @p_phase_code_sub,
			log_phase_code_prod = @p_phase_code_prod,
			log_last_updated = GETDATE()
		WHERE
		log_id = @p_id

		set @p_errors = null;
	end else begin 
		set @p_errors = '<Response>' + @w_errors + '</Response>';
	end 


END








GO
/****** Object:  StoredProcedure [dbo].[daily_report_reject_V2]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_reject_V2]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[daily_report_reject_V2] AS' 
END
GO



-- =============================================
-- Author:		<Nathaniel Unruh>
-- Create date: <1/2/18>
-- Description:	<Reject a daily report (V2)>
-- =============================================
ALTER PROCEDURE [dbo].[daily_report_reject_V2]
	-- Add the parameters for the stored procedure here
	@p_dr_id			int,
	@p_user				nvarchar(50),
	@p_user_id			nvarchar(50),
	@p_reject_reason	nvarchar(500),
	@p_errors			nvarchar(2048) out

	AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    declare @w_errors nvarchar(2000) = '';
	declare @w_status nvarchar(50);
	
	--grab the status

	Select @w_status = dr_status from daily_report_2
	where dr_id = @p_dr_id

	--no status check for now
	--if(@w_status <> 1) begin
	--		set @w_errors = @w_errors + '<Message type=''error''><Text>You can only approve a daily report after it has been submitted.</Text></Message>'
	--end


	--if everything looks good...
	if (@w_errors = '' ) begin

	--set the status to rejected
	Update daily_report_2
		SET 
			dr_status = 0,
			dr_rejector_date = GETDATE(),
			dr_rejector_time = GETDATE(),
			dr_rejector_datetime = GETDATE(),
			dr_rejector = @p_user,
			dr_rejector_userid = @p_user_id,
			dr_reject_reason = @p_reject_reason
	WHERE dr_id = @p_dr_id

		set @p_errors = null;
	end else begin 
		set @p_errors = '<Response>' + @w_errors + '</Response>';
	end 


END








GO
/****** Object:  StoredProcedure [dbo].[daily_report_submit_V2]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report_submit_V2]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[daily_report_submit_V2] AS' 
END
GO




-- =============================================
-- Author:		<Nathaniel Unruh>
-- Create date: <11/20/17>
-- Description:	<Submit daily report (V2)>
-- =============================================
ALTER PROCEDURE [dbo].[daily_report_submit_V2]
	-- Add the parameters for the stored procedure here
	@p_dr_id			int,
	@p_errors			nvarchar(2048) out

	AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    declare @w_errors nvarchar(2000) = '';
	declare @w_status nvarchar(50), @w_total_daily_hours decimal(5,1), @w_total_hours_to_go decimal(5,1);
	--grab the status and the total hours
	Select @w_status = dr_status, @w_total_daily_hours = ISNULL(dr_total_daily_hours,0) from daily_report_2
	where dr_id = @p_dr_id

	--grab the total of empl hours to go
	SET @w_total_hours_to_go = ISNULL((Select SUM(empl_hours_to_go) from daily_report_employee_2 where empl_dr_id = @p_dr_id),0)

	if(@w_total_daily_hours = 0) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>You must have entered in some hours.</Text></Message>'
	end

	if(@w_total_hours_to_go <> 0) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please spread all the hours.</Text></Message>'
	end

	--Now check to ensure there is a production line for each phase code entered in on the daily report.


	Create Table #phaseDailyReportCheck
	(
		phase_code						nvarchar(50),
		row_num							int
	)
	----load all of the incative jobs with their tool counts into the table
	Insert into #phaseDailyReportCheck
	(
		phase_code,
		row_num
	)
	(
	SELECT
      [hrs_phase_code],
	  ROW_NUMBER() OVER (ORDER BY hrs_dr_id) as row_number
  FROM [daily_report_v2_phases]
  where hrs_dr_id = @p_dr_id
  )
	DECLARE 
		@rows int,
		@cnt int = 1


	SELECT @rows = COUNT(*) FROM #phaseDailyReportCheck

	WHILE @cnt <= @rows BEGIN

	--avoid going into an infinite loop
		if(@cnt > 1000)
			break;

		DECLARE @w_curr_phase_code nvarchar(50)= (Select phase_code from #phaseDailyReportCheck where row_num = @cnt);
		DECLARE @w_curr_phase_code_exists bit = (Select MAX(1) from daily_report_project_log where log_phase_code = @w_curr_phase_code and log_type = 'Prod' and log_dr_id = @p_dr_id)
		if( @w_curr_phase_code_exists IS NULL)
		begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>A Production Log is required for Phase Code: ' + @w_curr_phase_code +'</Text></Message>'
		end
		SET @cnt = @cnt +1
	END
	IF OBJECT_ID('tempdb..#phaseDailyReportCheck') IS NOT NULL DROP TABLE #phaseDailyReportCheck

	--Error will be thrown if any phase codes do not have a production log entered in for them

	--if everything looks good...
	if (@w_errors = '' ) begin

	--set the status to submitted
	Update daily_report_2
		SET dr_status = 2,
			dr_foreman_submit_date = GETDATE(),
			dr_foreman_submit_time = GETDATE(),
			dr_foreman_submit_datetime = GETDATE()
	WHERE dr_id = @p_dr_id
	
	--grab the variables need for the notification

	Declare @w_super nvarchar(50),
			@w_job_number nvarchar(50),
			@w_job_name nvarchar(50),
			@w_foreman nvarchar(50),
			@w_total_hours decimal(5,1),
			@w_pm nvarchar(50),
			@w_pe nvarchar(50)

	Select  @w_super = dr_super_id,
			@w_job_number = dr_job_no,
			@w_job_name = dr_job_name,
			@w_foreman = dr_foreman,
			@w_total_hours = dr_total_daily_hours,
			@w_pm = dr_pm_id,
			@w_pe = dr_pe_id 
	from daily_report_2
	where dr_id = @p_dr_id

	--Send notifications to the supervisor, pm and pe for different project logs

	Create Table #logDailyNotifier
	(
		phase_code						nvarchar(50),
		log_description					nvarchar(2000),
		log_type						nvarchar(50),
		row_num							int
	)
	----load all all logs for this daily report
	Insert into #logDailyNotifier
	(
		phase_code,
		log_description,
		log_type,
		row_num
	)
	(
	SELECT
      log_phase_code,
	  log_description,
	  log_type,
	  ROW_NUMBER() OVER (ORDER BY log_id) as row_number
  FROM [daily_report_project_log]
  where log_dr_id = @p_dr_id and log_type <> 'Prod'
  )
	DECLARE 
		@rows_log int,
		@cnt_log int = 1

	SELECT @rows_log = COUNT(*) FROM #logDailyNotifier

	WHILE @cnt_log <= @rows_log BEGIN

		--avoid sending this into an infinite loop
		if(@cnt_log > 1000)
			break;

		DECLARE 
				@w_curr_type nvarchar(50),
				@w_description nvarchar(50);

		(Select 
				@w_curr_type = log_type,
				@w_description = log_description
		 from #logDailyNotifier where row_num = @cnt_log);

		if( @w_curr_type IN ('Impact','Rework'))
		begin

		--Send the impact notification to the superintendent
			INSERT INTO	dbo.catavolt_notification 
			(
				notification_type,
				notification_userid,
				notification_title,
				notification_body,
				userdata1,
		   		userdata2
			) 
	
		VALUES 
			(
				'MESSAGE',
				@w_super,
				'A new ' + @w_curr_type + ' Project Log has been submitted',
				'A new ' + @w_curr_type + ' Project Log has been submitted for Job: ' + @w_job_number + ' ' + @w_job_name + ' by: ' + @w_foreman,
				'dailyReportSubmitV2',
				@p_dr_id
			)

		--Send the notification to the PM
		if(@w_super <> @w_pm)
		begin
			INSERT INTO dbo.catavolt_notification 
				(
					notification_type,
					notification_userid,
					notification_title,
					notification_body,
					userdata1,
		   			userdata2
				) 
	
			VALUES 
				(
					'MESSAGE',
					@w_pm,
					'A new ' + @w_curr_type + ' Project Log has been submitted',
					'A new ' + @w_curr_type + ' Project Log has been submitted for Job: ' + @w_job_number + ' ' + @w_job_name + ' by: ' + @w_foreman,
					'dailyReportSubmitV2',
					@p_dr_id
				)
		end

		--send the notification to the pe
		if(@w_super <> @w_pe and @w_pe <> @w_pm and @w_pe IS NOT NULL and @w_pe <> '')
			begin
				INSERT INTO	dbo.catavolt_notification 
					(
						notification_type,
						notification_userid,
						notification_title,
						notification_body,
						userdata1,
		   				userdata2
					) 
	
				VALUES 
					(
						'MESSAGE',
						@w_super,
						'A new ' + @w_curr_type + ' Project Log has been submitted',
						'A new ' + @w_curr_type + ' Project Log has been submitted for Job: ' + @w_job_number + ' ' + @w_job_name + ' by: ' + @w_foreman,
						'dailyReportSubmitV2',
						@p_dr_id
					)
				end
		end
		

		if( @w_curr_type IN('Inspection','Incident'))
		begin

		--Send the notification to the safety director (currently Marc Daasch)
			INSERT INTO	dbo.catavolt_notification 
			(
				notification_type,
				notification_userid,
				notification_title,
				notification_body,
				userdata1,
		   		userdata2
			) 
	
		VALUES 
			(
				'MESSAGE',
				'm.daasch', -- needs to be updated to current safety director
				'A new Safety ' + @w_curr_type + ' Project Log has been submitted',
				'A new Safety ' + @w_curr_type + ' Project Log has been submitted for Job: ' + @w_job_number + ' ' + @w_job_name + ' by: ' + @w_foreman,
				'dailyReportSubmitV2',
				@p_dr_id
			)

		--Send the notification to the super
			INSERT INTO	dbo.catavolt_notification 
			(
				notification_type,
				notification_userid,
				notification_title,
				notification_body,
				userdata1,
		   		userdata2
			) 
	
		VALUES 
			(
				'MESSAGE',
				@w_super,
				'A new Safety ' + @w_curr_type + ' Project Log has been submitted',
				'A new Safety ' + @w_curr_type + ' Project Log has been submitted for Job: ' + @w_job_number + ' ' + @w_job_name + ' by: ' + @w_foreman,
				'dailyReportSubmitV2',
				@p_dr_id
			)
		end

		SET @cnt_log = @cnt_log +1
	END
	

	--send the notification that a daily has been submitted to the supervisor, pm, and pe


		INSERT INTO	dbo.catavolt_notification 
			(
				notification_type,
				notification_userid,
				notification_title,
				notification_body,
				userdata1,
		   		userdata2
			) 
	
		VALUES 
			(
				'MESSAGE',
				@w_super,
				'A new daily report has been submitted',
				'A new daily report has been submitted for Job: ' + @w_job_number + ' ' + @w_job_name + ' by: ' + @w_foreman + ' with total hours: ' + CONVERT(nvarchar(50),@w_total_hours) + '.',
				'dailyReportSubmitV2',
				@p_dr_id
			)

	if(@w_super <> @w_pm)
	begin
		INSERT INTO	dbo.catavolt_notification 
			(
				notification_type,
				notification_userid,
				notification_title,
				notification_body,
				userdata1,
		   		userdata2
			) 
	
		VALUES 
			(
				'MESSAGE',
				@w_pm,
				'A new daily report has been submitted',
				'A new daily report has been submitted for Job: ' + @w_job_number + ' ' + @w_job_name + ' by: ' + @w_foreman + ' with total hours: ' + CONVERT(nvarchar(50),@w_total_hours) + '.',
				'dailyReportSubmitV2',
				@p_dr_id
			)
	end

	if(@w_super <> @w_pe and @w_pe <> @w_pm and @w_pe IS NOT NULL and @w_pe <> '')
	begin
		INSERT INTO	dbo.catavolt_notification 
			(
				notification_type,
				notification_userid,
				notification_title,
				notification_body,
				userdata1,
		   		userdata2
			) 
	
		VALUES 
			(
				'MESSAGE',
				@w_pe,
				'A new daily report has been submitted',
				'A new daily report has been submitted for Job: ' + @w_job_number + ' ' + @w_job_name + ' by: ' + @w_foreman + ' with total hours: ' + CONVERT(nvarchar(50),@w_total_hours) + '.',
				'dailyReportSubmitV2',
				@p_dr_id
			)
	end

		set @p_errors = null;
	end else begin 
		set @p_errors = '<Response>' + @w_errors + '</Response>';
	end 


END








GO
/****** Object:  StoredProcedure [dbo].[daily_report2_copy]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report2_copy]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[daily_report2_copy] AS' 
END
GO




-- =============================================
-- Author:		<Nathaniel Unruh>
-- Create date: <11/14/17>
-- Description:	<Create action for the new daily report>
-- =============================================

ALTER PROCEDURE [dbo].[daily_report2_copy] 
	@p_create_date date,
	@p_create_time time,
	@p_job_no nvarchar(50),
	@p_job_name nvarchar(50),
	@p_shift_date date,
	@p_shift_time_end time,
	@p_shift_time_start time,
	@p_lunch_start_time time,
	@p_lunch_end_time time,
	@p_foreman nvarchar(50),
	@p_foreman_id nvarchar(50),
	@p_super nvarchar(50),
	@p_super_id nvarchar(50),
	@p_pm nvarchar(50),
	@p_pm_id nvarchar(50),
	@p_pe nvarchar(50),
	@p_pe_id nvarchar(50),
	@p_id	int,
	@p_errors nvarchar(2048) output
AS
BEGIN
	SET NOCOUNT ON;
	declare @w_errors nvarchar(2000) = ''
	--grab how many hours the guy has left to go.
	
	if(@p_job_no = '' or @p_job_no IS NULL) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please choose a Job.</Text></Message>'
	end
	if(@p_shift_time_start IS NULL) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter a Shift Start Time</Text></Message>'
	end
	if(@p_shift_time_end IS NULL) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter a Shift End Time</Text></Message>'
	end
	if(@p_lunch_start_time IS NULL) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter a Lunch Start Time</Text></Message>'
	end
	if(@p_lunch_end_time IS NULL) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter a Lunch End Time</Text></Message>'
	end
	if(@p_shift_date = '' or @p_shift_date IS NULL) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please choose a Shift Date.</Text></Message>'
	end
	if(@p_super_id = '' or @p_super_id IS NULL) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please choose a Superintendent</Text></Message>'
	end
	if(@p_pm_id = '' or @p_pm_id IS NULL) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please choose a Project Manager</Text></Message>'
	end

	if(@w_errors = '')
	BEGIN
	--if everything was entered in create the report

		INSERT INTO daily_report_2
			(
			dr_create_date,
			dr_create_time,
			dr_job_name,
			dr_job_no,
			dr_shift_date,
			dr_shift_time_start,
			dr_shift_time_end,
			dr_lunch_time_start,
			dr_lunch_time_end,
			dr_foreman,
			dr_foreman_id,
			dr_super,
			dr_super_id,
			dr_pm,
			dr_pm_id,
			dr_pe,
			dr_pe_id,
			dr_status,
			dr_total_daily_hours
			)
		VALUES
			(
			@p_create_date,
			@p_create_time,
			@p_job_name,
			@p_job_no,
			@p_shift_date,
			@p_shift_time_start,
			@p_shift_time_end,
			@p_lunch_start_time,
			@p_lunch_end_time,
			@p_foreman,
			@p_foreman_id,
			@p_super,
			@p_super_id,
			@p_pm,
			@p_pm_id,
			@p_pe,
			@p_pe_id,
			1, --status of open
			0
			);
	Declare @w_new_id int = SCOPE_IDENTITY();


	
	Create Table #addEmployees
	(
		name				nvarchar(50),
		name_id				nvarchar(50),
		department			nvarchar(50),
		company				nvarchar(50),
		row_num				int
	)
	----load all of the incative jobs with their tool counts into the table
	Insert into #addEmployees
	(
		name,
		name_id,
		department,
		company,
		row_num
	)
	(

	SELECT
      [empl_name],
	  [empl_name_id],
	  [empl_department],
	  [empl_company],
	  ROW_NUMBER() OVER (ORDER BY empl_id) as row_number
  FROM [daily_report_employee_2]
  where empl_dr_id = @p_id
  )
	DECLARE 
		@rows int,
		@cnt int = 1


	SELECT @rows = COUNT(*) FROM #addEmployees

	WHILE @cnt <= @rows BEGIN

	--grab the variables for the employee the loop is on
		DECLARE @w_empl_name nvarchar(50), @w_empl_name_id nvarchar(50), @w_empl_department nvarchar(50), @w_empl_company nvarchar(50);
		Select @w_empl_name = name, @w_empl_name_id = name_id, @w_empl_department = department, @w_empl_company = company from #addEmployees where row_num = @cnt;
	
	--check to make sure employee is still active
		DECLARE @w_employee_exists bit = (Select MAX(1) from daily_report_employee_master_1 where Employee_Code = @w_empl_name_id and Department_Code = @w_empl_department and Employment_Status = 'A')
		
		if( @w_employee_exists = 1)
		begin
			INSERT INTO daily_report_employee_2
			(
				empl_dr_id,
				empl_name,
				empl_name_id,
				empl_hours,
				empl_hours_to_go,
				empl_datetime_added,
				empl_added_by,
				empl_department,
				empl_company
			)
			Values
			(
				@w_new_id,
				@w_empl_name,
				@w_empl_name_id,
				0,
				0,
				GETDATE(),
				@p_foreman_id,
				@w_empl_department,
				@w_empl_company
			)
		end
		SET @cnt = @cnt +1
	END
	IF OBJECT_ID('tempdb..#addEmployees') IS NOT NULL DROP TABLE #addEmployees

	Update daily_report_2 
	SET dr_empl_number = (SELECT COUNT(empl_id) from daily_report_employee_2 where empl_dr_id = @w_new_id)
	where dr_id = @w_new_id

	set @p_errors = null;
	end else begin 
		set @p_errors = '<Response>' + @w_errors + '</Response>';
	end 
END










GO
/****** Object:  StoredProcedure [dbo].[daily_report2_create]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_report2_create]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[daily_report2_create] AS' 
END
GO



-- =============================================
-- Author:		<Nathaniel Unruh>
-- Create date: <11/14/17>
-- Description:	<Create action for the new daily report>
-- =============================================

ALTER PROCEDURE [dbo].[daily_report2_create] 
	@p_create_date date,
	@p_create_time time,
	@p_job_no nvarchar(50),
	@p_job_name nvarchar(50),
	@p_shift_date date,
	@p_shift_time_end time,
	@p_shift_time_start time,
	@p_lunch_start_time time,
	@p_lunch_end_time time,
	@p_foreman nvarchar(50),
	@p_foreman_id nvarchar(50),
	@p_super nvarchar(50),
	@p_super_id nvarchar(50),
	@p_pm nvarchar(50),
	@p_pm_id nvarchar(50),
	@p_pe nvarchar(50),
	@p_pe_id nvarchar(50),
	@p_errors nvarchar(2048) output
AS
BEGIN
	SET NOCOUNT ON;
	declare @w_errors nvarchar(2000) = ''
	--grab how many hours the guy has left to go.
	
	if(@p_job_no = '' or @p_job_no IS NULL) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please choose a Job.</Text></Message>'
	end
	if(@p_shift_time_start IS NULL) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter a Shift Start Time</Text></Message>'
	end
	if(@p_shift_time_end IS NULL) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter a Shift End Time</Text></Message>'
	end
	if(@p_lunch_start_time IS NULL) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter a Lunch Start Time</Text></Message>'
	end
	if(@p_lunch_end_time IS NULL) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please enter a Lunch End Time</Text></Message>'
	end
	if(@p_shift_date = '' or @p_shift_date IS NULL) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please choose a Shift Date.</Text></Message>'
	end
	if(@p_super_id = '' or @p_super_id IS NULL) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please choose a Superintendent</Text></Message>'
	end
	if(@p_pm_id = '' or @p_pm_id IS NULL) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Please choose a Project Manager</Text></Message>'
	end

	if(@w_errors = '')
	BEGIN
	--if everything was entered in create the report
		INSERT INTO daily_report_2
			(
			dr_create_date,
			dr_create_time,
			dr_job_name,
			dr_job_no,
			dr_shift_date,
			dr_shift_time_start,
			dr_shift_time_end,
			dr_lunch_time_start,
			dr_lunch_time_end,
			dr_foreman,
			dr_foreman_id,
			dr_super,
			dr_super_id,
			dr_pm,
			dr_pm_id,
			dr_pe,
			dr_pe_id,
			dr_status,
			dr_total_daily_hours,
			dr_empl_number
			)
		VALUES
			(
			@p_create_date,
			@p_create_time,
			@p_job_name,
			@p_job_no,
			@p_shift_date,
			@p_shift_time_start,
			@p_shift_time_end,
			@p_lunch_start_time,
			@p_lunch_end_time,
			@p_foreman,
			@p_foreman_id,
			@p_super,
			@p_super_id,
			@p_pm,
			@p_pm_id,
			@p_pe,
			@p_pe_id,
			1, -- status of open
			0,
			0
			);
			set @p_errors = null;
	end else begin 
		set @p_errors = '<Response>' + @w_errors + '</Response>';
	end 
END










GO
/****** Object:  StoredProcedure [dbo].[daily_reportv2_status_check]    Script Date: 2/22/2019 4:17:32 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[daily_reportv2_status_check]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[daily_reportv2_status_check] AS' 
END
GO












-- =============================================
-- Author:		<Sweigart, Harley>
-- Create date: <June 26th, 2017>
-- Description:	<Function to check if a requisition can be deleted or edited>
-- =============================================
ALTER PROCEDURE [dbo].[daily_reportv2_status_check]
	-- Add the parameters for the stored procedure here
	@p_random				nvarchar(50),
	@p_id					int,
	@p_errors				nvarchar(2048) out

	AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	declare @w_errors nvarchar(2000) = ''

	declare @w_status nvarchar(50) = (select dr_status from daily_report_2 where dr_id = @p_id)

if (@w_status <> '0' and @w_status <> '1' and @p_random = 'Delete') begin 
	set @w_errors = @w_errors + '<Message type=''error''><Text>You cannot delete once a daily report has been submitted.</Text><PropertyList><Property name=''p_Date Needed'' /></PropertyList></Message>'
end

if (@w_status <> '0' and @w_status <> '1' and @p_random = 'Edit') begin 
	set @w_errors = @w_errors + '<Message type=''error''><Text>You cannot edit once a daily report has been submitted.</Text><PropertyList><Property name=''p_Date Needed'' /></PropertyList></Message>'
end

	if (@w_errors = '' ) begin

		set @p_errors = null;
	end else begin 
		set @p_errors = '<Response>' + @w_errors + '</Response>';
	end 


END







GO
